/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.concept.OntologyConcept;
import ai.grakn.engine.controller.GraqlController;
import ai.grakn.engine.factory.EngineGraknGraphFactory;
import ai.grakn.exception.GraknServerException;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import mjson.Json;
import spark.Request;
import spark.Response;
import spark.Service;

@Path(value="/graph")
public class ConceptController {
    private static final int separationDegree = 1;
    private final EngineGraknGraphFactory factory;
    private final Timer conceptIdGetTimer;
    private final Timer ontologyGetTimer;

    public ConceptController(EngineGraknGraphFactory factory, Service spark, MetricRegistry metricRegistry) {
        this.factory = factory;
        this.conceptIdGetTimer = metricRegistry.timer(MetricRegistry.name(ConceptController.class, (String[])new String[]{"concept-by-identifier"}));
        this.ontologyGetTimer = metricRegistry.timer(MetricRegistry.name(ConceptController.class, (String[])new String[]{"ontology"}));
        spark.get("/graph/concept/:id", this::conceptByIdentifier);
        spark.get("/graph/ontology", this::ontology);
    }

    /*
     * Exception decompiling
     */
    @GET
    @Path(value="concept/{id}")
    @ApiOperation(value="Return the HAL representation of a given concept.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="identifier", value="Identifier of the concept", required=true, dataType="string", paramType="path"), @ApiImplicitParam(name="keyspace", value="Name of graph to use", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="offsetEmbedded", value="Offset to begin at for embedded HAL concepts", required=true, dataType="boolean", paramType="query"), @ApiImplicitParam(name="limitEmbedded", value="Limit on the number of embedded HAL concepts", required=true, dataType="boolean", paramType="query")})
    private Json conceptByIdentifier(Request request, Response response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @GET
    @Path(value="/ontology")
    @ApiOperation(value="Produces a Json object containing meta-ontology types instances.", notes="The built Json object will contain ontology nodes divided in roles, entities, relations and resources.", response=Json.class)
    @ApiImplicitParam(name="keyspace", value="Name of graph to use", dataType="string", paramType="query")
    private String ontology(Request request, Response response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static Concept retrieveExistingConcept(GraknGraph graph, ConceptId conceptId) {
        Concept concept = graph.getConcept(conceptId);
        if (ConceptController.notPresent(concept)) {
            throw GraknServerException.noConceptFound((ConceptId)conceptId, (String)graph.getKeyspace());
        }
        return concept;
    }

    static void validateRequest(Request request, String ... contentTypes) {
        String acceptType = GraqlController.getAcceptType(request);
        if (!Arrays.asList(contentTypes).contains(acceptType)) {
            throw GraknServerException.unsupportedContentType((String)acceptType);
        }
    }

    private List<String> subLabels(OntologyConcept ontologyConcept) {
        return ontologyConcept.subs().stream().filter(concept -> concept.isImplicit() == false).map(OntologyConcept::getLabel).map(Label::getValue).collect(Collectors.toList());
    }

    static String mandatoryRequestParameter(Request request, String parameter) {
        return Optional.ofNullable(request.params(parameter)).orElseThrow(() -> GraknServerException.requestMissingParameters((String)parameter));
    }

    private static boolean notPresent(@Nullable Concept concept) {
        return concept == null;
    }
}

