/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.GraknGraph;
import ai.grakn.GraknTxType;
import ai.grakn.concept.Entity;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.engine.SystemKeyspace;
import ai.grakn.engine.factory.EngineGraknGraphFactory;
import ai.grakn.exception.GraknServerException;
import ai.grakn.util.ErrorMessage;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.exporter.common.TextFormat;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Service;

public class SystemController {
    private static final String PROMETHEUS_CONTENT_TYPE = "text/plain; version=0.0.4";
    private static final String PROMETHEUS = "prometheus";
    public static final String JSON = "json";
    private final Logger LOG = LoggerFactory.getLogger(SystemController.class);
    private final EngineGraknGraphFactory factory;
    private final MetricRegistry metricRegistry;
    private final ObjectMapper mapper;
    private final DropwizardExports prometheusMetricWrapper;
    private final CollectorRegistry prometheusRegistry;

    public SystemController(EngineGraknGraphFactory factory, Service spark, MetricRegistry metricRegistry) {
        this.factory = factory;
        this.metricRegistry = metricRegistry;
        this.prometheusMetricWrapper = new DropwizardExports(metricRegistry);
        this.prometheusRegistry = new CollectorRegistry();
        this.prometheusRegistry.register((Collector)this.prometheusMetricWrapper);
        spark.get("/keyspaces", this::getKeyspaces);
        spark.get("/configuration", this::getConfiguration);
        spark.get("/metrics", this::getMetrics);
        spark.get("/initialise", this::initialiseSession);
        spark.delete("/deleteKeyspace", this::deleteKeyspace);
        TimeUnit rateUnit = TimeUnit.SECONDS;
        TimeUnit durationUnit = TimeUnit.SECONDS;
        boolean showSamples = false;
        MetricFilter filter = MetricFilter.ALL;
        this.mapper = new ObjectMapper().registerModule((Module)new MetricsModule(rateUnit, durationUnit, false, filter));
    }

    @GET
    @Path(value="/initialise")
    @ApiOperation(value="Initialise a grakn session - add the keyspace to the system graph and return configured properties.")
    @ApiImplicitParam(name="keyspace", value="Name of graph to use", required=true, dataType="string", paramType="query")
    private String initialiseSession(Request request, Response response) {
        String keyspace = request.queryParams("keyspace");
        boolean keyspaceInitialised = this.factory.systemKeyspace().ensureKeyspaceInitialised(keyspace);
        if (keyspaceInitialised) {
            return this.getConfiguration(request, response);
        }
        throw GraknServerException.internalError((String)("Unable to instantiate system keyspace " + keyspace));
    }

    @DELETE
    @Path(value="/deleteKeyspace")
    @ApiOperation(value="Delete a keyspace from the system graph.")
    @ApiImplicitParam(name="keyspace", value="Name of graph to use", required=true, dataType="string", paramType="query")
    private boolean deleteKeyspace(Request request, Response response) {
        String keyspace = request.queryParams("keyspace");
        boolean deletionComplete = this.factory.systemKeyspace().deleteKeyspace(keyspace);
        if (deletionComplete) {
            this.LOG.info("Keyspace {} deleted", (Object)keyspace);
            response.status(200);
            return true;
        }
        throw GraknServerException.couldNotDelete((String)keyspace);
    }

    @GET
    @Path(value="/configuration")
    @ApiOperation(value="Get config which is used to build graphs")
    @ApiImplicitParam(name="graphConfig", value="The type of graph config to return", required=true, dataType="string", paramType="path")
    private String getConfiguration(Request request, Response response) {
        String graphConfig = request.queryParams("graphConfig");
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.factory.properties());
        switch (graphConfig != null ? graphConfig : "default") {
            case "default": {
                break;
            }
            case "computer": {
                properties.setProperty("factory.internal", properties.get("factory.analytics").toString());
                break;
            }
            default: {
                throw GraknServerException.internalError((String)("Unrecognised graph config: " + graphConfig));
            }
        }
        Json config = Json.make((Object)properties);
        if (config.has("JWT.secret")) {
            config.delAt("JWT.secret");
        }
        return config.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/keyspaces")
    @ApiOperation(value="Get all the key spaces that have been opened")
    private String getKeyspaces(Request request, Response response) {
        try (GraknGraph graph = this.factory.getGraph("graknSystem", GraknTxType.WRITE);){
            ResourceType keyspaceName = (ResourceType)graph.getOntologyConcept(SystemKeyspace.KEYSPACE_RESOURCE);
            Json result = Json.array();
            for (Entity keyspace : ((EntityType)graph.getOntologyConcept(SystemKeyspace.KEYSPACE_ENTITY)).instances()) {
                Collection names = keyspace.resources(new ResourceType[]{keyspaceName});
                if (names.size() != 1) {
                    throw GraknServerException.internalError((String)ErrorMessage.INVALID_SYSTEM_KEYSPACE.getMessage(new Object[]{" keyspace " + keyspace.getId() + " has no unique name."}));
                }
                result.add(((Resource)names.iterator().next()).getValue());
            }
            String string = result.toString();
            return string;
        }
        catch (Exception e) {
            this.LOG.error("While retrieving keyspace list:", (Throwable)e);
            throw GraknServerException.serverException((int)500, (Exception)e);
        }
    }

    @GET
    @Path(value="/metrics")
    @ApiOperation(value="Exposes internal metrics")
    @ApiImplicitParams(value={@ApiImplicitParam(name="format", value="prometheus", dataType="string", paramType="path")})
    private String getMetrics(Request request, Response response) throws IOException {
        response.header("Cache-Control", "must-revalidate,no-cache,no-store");
        response.status(200);
        Optional<String> format = Optional.ofNullable(request.queryParams("format"));
        String dFormat = format.orElse(JSON);
        if (dFormat.equals(PROMETHEUS)) {
            response.type(PROMETHEUS_CONTENT_TYPE);
            StringWriter writer1 = new StringWriter();
            TextFormat.write004((Writer)writer1, (Enumeration)this.prometheusRegistry.metricFamilySamples());
            return ((Object)writer1).toString();
        }
        if (dFormat.equals(JSON)) {
            response.type("application/json");
            ObjectWriter writer = this.mapper.writer();
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                writer.writeValue((OutputStream)output, (Object)this.metricRegistry);
                String string = new String(output.toByteArray(), "UTF-8");
                return string;
            }
        }
        throw new IllegalArgumentException("Unexpected format " + dFormat);
    }
}

