/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.engine.TaskId;
import ai.grakn.engine.TaskStatus;
import ai.grakn.engine.controller.util.Requests;
import ai.grakn.engine.tasks.BackgroundTask;
import ai.grakn.engine.tasks.manager.TaskConfiguration;
import ai.grakn.engine.tasks.manager.TaskManager;
import ai.grakn.engine.tasks.manager.TaskSchedule;
import ai.grakn.engine.tasks.manager.TaskState;
import ai.grakn.exception.GraknBackendException;
import ai.grakn.exception.GraknServerException;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import mjson.Json;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Service;

@Path(value="/tasks")
@Api(value="/tasks", description="Endpoints used to query and control queued background tasks.", produces="application/json")
public class TasksController {
    private static final Logger LOG = LoggerFactory.getLogger(TasksController.class);
    private static final TaskState.Priority DEFAULT_TASK_PRIORITY = TaskState.Priority.LOW;
    private static final int MAX_THREADS = 10;
    private static final Duration MAX_EXECUTION_TIME = Duration.ofSeconds(10L);
    private final TaskManager manager;
    private final ExecutorService executor;
    private final Timer createTasksTimer;
    private final Timer stopTaskTimer;
    private final Timer getTaskTimer;
    private final Timer getTasksTimer;

    public TasksController(Service spark, TaskManager manager, MetricRegistry metricRegistry) {
        if (manager == null) {
            throw GraknServerException.internalError((String)"Task manager has not been instantiated.");
        }
        this.manager = manager;
        this.getTasksTimer = metricRegistry.timer(MetricRegistry.name(TasksController.class, (String[])new String[]{"get-tasks"}));
        this.getTaskTimer = metricRegistry.timer(MetricRegistry.name(TasksController.class, (String[])new String[]{"get-task"}));
        this.stopTaskTimer = metricRegistry.timer(MetricRegistry.name(TasksController.class, (String[])new String[]{"stop-task"}));
        this.createTasksTimer = metricRegistry.timer(MetricRegistry.name(TasksController.class, (String[])new String[]{"create-tasks"}));
        spark.get("/tasks", this::getTasks);
        spark.get("/tasks/:id", this::getTask);
        spark.put("/tasks/:id/stop", this::stopTask);
        spark.post("/tasks", this::createTasks);
        spark.exception(GraknServerException.class, (e, req, res) -> this.handleNotFoundInStorage(e, res));
        spark.exception(GraknBackendException.class, (e, req, res) -> this.handleNotFoundInStorage(e, res));
        this.executor = Executors.newFixedThreadPool(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/")
    @ApiOperation(value="Get tasks matching a specific TaskStatus.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="status", value="TaskStatus as string.", dataType="string", paramType="query"), @ApiImplicitParam(name="className", value="Class name of BackgroundTask Object.", dataType="string", paramType="query"), @ApiImplicitParam(name="creator", value="Who instantiated these tasks.", dataType="string", paramType="query"), @ApiImplicitParam(name="limit", value="Limit the number of entries in the returned result.", dataType="integer", paramType="query"), @ApiImplicitParam(name="offset", value="Use in conjunction with limit for pagination.", dataType="integer", paramType="query")})
    private Json getTasks(Request request, Response response) {
        TaskStatus status = null;
        String className = request.queryParams("className");
        String creator = request.queryParams("creator");
        int limit = 0;
        int offset = 0;
        if (request.queryParams("limit") != null) {
            limit = Integer.parseInt(request.queryParams("limit"));
        }
        if (request.queryParams("offset") != null) {
            offset = Integer.parseInt(request.queryParams("offset"));
        }
        if (request.queryParams("status") != null) {
            status = TaskStatus.valueOf((String)request.queryParams("status"));
        }
        Timer.Context context = this.getTasksTimer.time();
        try {
            Json result = Json.array();
            this.manager.storage().getTasks(status, className, creator, null, limit, offset).stream().map(this::serialiseStateSubset).forEach(arg_0 -> ((Json)result).add(arg_0));
            response.status(200);
            response.type("application/json");
            Json json = result;
            return json;
        }
        finally {
            context.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{id}")
    @ApiOperation(value="Get the state of a specific task by its ID.", produces="application/json")
    @ApiImplicitParam(name="uuid", value="ID of task.", required=true, dataType="string", paramType="path")
    private Json getTask(Request request, Response response) {
        String id = request.params("id");
        Timer.Context context = this.getTaskTimer.time();
        try {
            response.status(200);
            response.type("application/json");
            Json json = this.serialiseStateFull(this.manager.storage().getState(TaskId.of((String)id)));
            return json;
        }
        finally {
            context.stop();
        }
    }

    @PUT
    @Path(value="/{id}/stop")
    @ApiOperation(value="Stop a running or paused task.")
    @ApiImplicitParam(name="uuid", value="ID of task.", required=true, dataType="string", paramType="path")
    private Json stopTask(Request request, Response response) {
        String id = request.params(":id");
        try (Timer.Context context = this.stopTaskTimer.time();){
            this.manager.stopTask(TaskId.of((String)id));
            response.status(200);
            response.type("application/json");
            Json json = Json.object();
            return json;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @POST
    @Path(value="/")
    @ApiOperation(value="Schedule a set of tasks.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tasks", value="JSON Array containing an ordered list of task parameters and comfigurations.", required=true, dataType="List", paramType="body")})
    private Json createTasks(Request request, Response response) {
        Json requestBodyAsJson = this.bodyAsJson(request);
        if (requestBodyAsJson.has("value")) {
            requestBodyAsJson = requestBodyAsJson.at("value");
        }
        if (!requestBodyAsJson.has("tasks")) {
            LOG.error("Malformed request body: {}", (Object)requestBodyAsJson);
            throw GraknServerException.requestMissingBodyParameters((String)"tasks");
        }
        LOG.debug("Received request {}", (Object)request);
        List taskJsonList = requestBodyAsJson.at("tasks").asJsonList();
        Json responseJson = Json.array();
        response.type(ContentType.APPLICATION_JSON.getMimeType());
        Timer.Context context = this.createTasksTimer.time();
        try {
            List<TaskStateWithConfiguration> taskStates = this.parseTasks(taskJsonList);
            CompletableFuture<List<Json>> completableFuture = this.saveTasksInQueue(taskStates);
            try {
                Json json = this.buildResponseForTasks(response, responseJson, completableFuture);
                return json;
            }
            catch (InterruptedException | TimeoutException e) {
                LOG.error("Task interrupted", (Throwable)e);
                response.status(500);
                Json json = Json.object();
                context.stop();
                return json;
            }
            catch (Exception e) {
                LOG.error("Exception while processing batch of tasks", (Throwable)e);
                response.status(500);
                Json json = Json.object();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                context.stop();
                return json;
            }
        }
        finally {
            context.stop();
        }
    }

    private Json buildResponseForTasks(Response response, Json responseJson, CompletableFuture<List<Json>> completableFuture) throws InterruptedException, ExecutionException, TimeoutException {
        List<Json> results = completableFuture.get(MAX_EXECUTION_TIME.getSeconds(), TimeUnit.SECONDS);
        boolean hasFailures = false;
        for (Json resultForTask : results) {
            responseJson.add(resultForTask);
            if (resultForTask.at("code").asInteger() == 200) continue;
            LOG.error("Could not add task {}", (Object)resultForTask);
            hasFailures = true;
        }
        if (!hasFailures) {
            response.status(200);
        } else if (responseJson.asJsonList().size() > 0) {
            response.status(202);
        } else {
            response.status(500);
        }
        return responseJson;
    }

    private List<TaskStateWithConfiguration> parseTasks(List<Json> taskJsonList) {
        ArrayList<TaskStateWithConfiguration> taskStates = new ArrayList<TaskStateWithConfiguration>();
        for (int i = 0; i < taskJsonList.size(); ++i) {
            Json singleTaskJson = taskJsonList.get(i);
            try {
                taskStates.add(new TaskStateWithConfiguration(this.extractParametersAndProcessTask(singleTaskJson), this.extractConfiguration(singleTaskJson), i));
                continue;
            }
            catch (Exception e) {
                LOG.error("Malformed request at {}", (Object)singleTaskJson, (Object)e);
                throw e;
            }
        }
        return taskStates;
    }

    private CompletableFuture<List<Json>> saveTasksInQueue(List<TaskStateWithConfiguration> taskStates) {
        List futures = taskStates.stream().map(taskStateWithConfiguration -> CompletableFuture.supplyAsync(() -> this.addTaskToManager((TaskStateWithConfiguration)taskStateWithConfiguration), this.executor)).collect(Collectors.toList());
        return TasksController.all(futures);
    }

    private Json extractConfiguration(Json taskJson) {
        if (taskJson.has("configuration")) {
            Json config = taskJson.at("configuration");
            if (config.isNull()) {
                return Json.nil();
            }
            if (!config.isObject()) {
                throw GraknServerException.requestMissingParameters((String)"configuration");
            }
            return config;
        }
        return Json.object();
    }

    private Json addTaskToManager(TaskStateWithConfiguration taskState) {
        Json singleTaskReturnJson = Json.object().set("index", (Object)taskState.getIndex());
        try {
            this.manager.addTask(taskState.getTaskState(), TaskConfiguration.of(taskState.getConfiguration()));
            singleTaskReturnJson.set("id", (Object)taskState.getTaskState().getId().getValue());
            singleTaskReturnJson.set("code", (Object)200);
        }
        catch (Exception e) {
            LOG.error("Server error while adding the task", (Throwable)e);
            singleTaskReturnJson.set("code", (Object)500);
        }
        return singleTaskReturnJson;
    }

    private static <T> CompletableFuture<List<T>> all(List<CompletableFuture<T>> cf) {
        return CompletableFuture.allOf(cf.toArray(new CompletableFuture[cf.size()])).thenApply(v -> cf.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    private TaskState extractParametersAndProcessTask(Json singleTaskJson) {
        Function<String, Optional<String>> extractor = p -> Optional.ofNullable(singleTaskJson.at(p));
        String className = ((Json)Requests.mandatoryQueryParameter(extractor, "className")).asString();
        String createdBy = ((Json)Requests.mandatoryQueryParameter(extractor, "creator")).asString();
        String runAtTime = ((Json)Requests.mandatoryQueryParameter(extractor, "runAt")).asString();
        String intervalParam = extractor.apply("interval").map(Json::asString).orElse(null);
        String priorityParam = extractor.apply("priority").map(Json::asString).orElse(null);
        return this.processTask(className, createdBy, runAtTime, intervalParam, priorityParam);
    }

    private TaskState processTask(String className, String createdBy, String runAtTime, String intervalParam, String priorityParam) {
        TaskState.Priority priority;
        TaskSchedule schedule;
        try {
            Optional<Duration> optionalInterval = Optional.ofNullable(intervalParam).map(Long::valueOf).map(Duration::ofMillis);
            Instant time = Instant.ofEpochMilli(Long.parseLong(runAtTime));
            schedule = optionalInterval.map(interval -> TaskSchedule.recurring(time, interval)).orElse(TaskSchedule.at(time));
            priority = Optional.ofNullable(priorityParam).map(TaskState.Priority::valueOf).orElse(DEFAULT_TASK_PRIORITY);
        }
        catch (Exception e) {
            throw GraknServerException.serverException((int)400, (Exception)e);
        }
        Class<?> clazz = this.getClass(className);
        return TaskState.of(clazz, createdBy, schedule, priority);
    }

    private Json bodyAsJson(Request request) {
        String requestBody = request.body();
        if (requestBody.isEmpty()) {
            return Json.object();
        }
        try {
            return Json.read((String)requestBody);
        }
        catch (Exception e) {
            LOG.error("Malformed json in body of request {}", (Object)requestBody, (Object)e);
            throw GraknServerException.serverException((int)400, (Exception)e);
        }
    }

    private Class<?> getClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (!BackgroundTask.class.isAssignableFrom(clazz)) {
                throw GraknServerException.invalidTask((String)className);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw GraknServerException.invalidTask((String)className);
        }
    }

    private void handleNotFoundInStorage(Exception exception, Response response) {
        if (exception instanceof GraknServerException) {
            response.status(((GraknServerException)exception).getStatus());
            response.body(Json.object((Object[])new Object[]{"exception", exception.getMessage()}).toString());
        } else {
            response.status(404);
        }
    }

    private Json serialiseStateSubset(TaskState state) {
        return Json.object().set("id", (Object)state.getId().getValue()).set("status", (Object)state.status().name()).set("creator", (Object)state.creator()).set("className", (Object)state.taskClass().getName()).set("runAt", (Object)state.schedule().runAt().toEpochMilli()).set("recurring", (Object)state.schedule().isRecurring());
    }

    private Json serialiseStateFull(TaskState state) {
        return this.serialiseStateSubset(state).set("interval", state.schedule().interval().map(Duration::toMillis).orElse(null)).set("recurring", (Object)state.schedule().isRecurring()).set("exception", (Object)state.exception()).set("stackTrace", (Object)state.stackTrace()).set("engineID", state.engineID() != null ? state.engineID().value() : null);
    }

    private static class TaskStateWithConfiguration {
        private final TaskState taskState;
        private Json configuration;
        private final int index;

        TaskStateWithConfiguration(TaskState taskState, Json configuration, int index) {
            this.taskState = taskState;
            this.configuration = configuration;
            this.index = index;
        }

        public TaskState getTaskState() {
            return this.taskState;
        }

        public int getIndex() {
            return this.index;
        }

        public Json getConfiguration() {
            return this.configuration;
        }
    }
}

