/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.factory;

import ai.grakn.GraknGraph;
import ai.grakn.GraknTxType;
import ai.grakn.engine.SystemKeyspace;
import ai.grakn.factory.FactoryBuilder;
import java.util.Map;
import java.util.Properties;

public class EngineGraknGraphFactory {
    private final Properties properties = new Properties();
    private final String engineURI;
    private final SystemKeyspace systemKeyspace;

    public static EngineGraknGraphFactory createAndLoadSystemOntology(Properties properties) {
        return new EngineGraknGraphFactory(properties, true);
    }

    public static EngineGraknGraphFactory create(Properties properties) {
        return new EngineGraknGraphFactory(properties, false);
    }

    private EngineGraknGraphFactory(Properties properties, boolean loadOntology) {
        this.properties.putAll((Map<?, ?>)properties);
        this.engineURI = properties.getProperty("server.host") + ":" + properties.getProperty("server.port");
        this.systemKeyspace = new SystemKeyspace(this, loadOntology);
    }

    public synchronized void refreshConnections() {
        FactoryBuilder.refresh();
    }

    public GraknGraph getGraph(String keyspace, GraknTxType type) {
        if (!keyspace.equals("graknSystem")) {
            this.systemKeyspace.ensureKeyspaceInitialised(keyspace);
        }
        return FactoryBuilder.getFactory((String)keyspace, (String)this.engineURI, (Properties)this.properties).open(type);
    }

    public Properties properties() {
        return this.properties;
    }

    public SystemKeyspace systemKeyspace() {
        return this.systemKeyspace;
    }
}

