/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.loader;

import ai.grakn.GraknGraph;
import ai.grakn.engine.postprocessing.GraphMutators;
import ai.grakn.engine.postprocessing.PostProcessingTask;
import ai.grakn.engine.postprocessing.UpdatingInstanceCountTask;
import ai.grakn.engine.tasks.BackgroundTask;
import ai.grakn.engine.tasks.manager.TaskConfiguration;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Query;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.util.ErrorMessage;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import mjson.Json;

public class MutatorTask
extends BackgroundTask {
    private final QueryBuilder builder = Graql.withoutGraph().infer(false);

    @Override
    public boolean start() {
        Collection<Query> inserts = this.getInserts(this.configuration());
        this.metricRegistry().histogram(MetricRegistry.name(MutatorTask.class, (String[])new String[]{"jobs"})).update(inserts.size());
        String keyspace = this.configuration().json().at("keyspace").asString();
        int maxRetry = this.engineConfiguration().getPropertyAsInt("loader.repeat-commits");
        GraphMutators.runBatchMutationWithRetry(this.factory(), keyspace, maxRetry, graph -> this.insertQueriesInOneTransaction((GraknGraph)graph, inserts));
        return true;
    }

    private boolean insertQueriesInOneTransaction(GraknGraph graph, Collection<Query> inserts) {
        try (Timer.Context context = this.metricRegistry().timer(MetricRegistry.name(MutatorTask.class, (String[])new String[]{"execution"})).time();){
            inserts.forEach(q -> {
                try (Timer.Context contextSingle = this.metricRegistry().timer(MetricRegistry.name(MutatorTask.class, (String[])new String[]{"execution-single"})).time();){
                    q.withGraph(graph).execute();
                }
            });
            Optional result = graph.admin().commitNoLogs();
            if (result.isPresent()) {
                String logs = (String)result.get();
                this.addTask(PostProcessingTask.createTask(this.getClass(), this.engineConfiguration().getPropertyAsInt("tasks.postprocessing.delay")), PostProcessingTask.createConfig(graph.getKeyspace(), logs));
                this.addTask(UpdatingInstanceCountTask.createTask(this.getClass()), UpdatingInstanceCountTask.createConfig(graph.getKeyspace(), logs));
            }
            boolean bl = true;
            return bl;
        }
    }

    private Collection<Query> getInserts(TaskConfiguration configuration) {
        if (configuration.json().has("mutations")) {
            return configuration.json().at("mutations").asJsonList().stream().map(Json::asString).map(arg_0 -> ((QueryBuilder)this.builder).parse(arg_0)).map(query -> {
                if (query.isReadOnly()) {
                    throw new IllegalArgumentException(ErrorMessage.READ_ONLY_QUERY.getMessage(new Object[]{query.toString()}));
                }
                return query;
            }).collect(Collectors.toList());
        }
        throw new IllegalArgumentException(ErrorMessage.ILLEGAL_ARGUMENT_EXCEPTION.getMessage(new Object[]{"No inserts", configuration}));
    }
}

