/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.postprocessing;

import ai.grakn.GraknGraph;
import ai.grakn.GraknTxType;
import ai.grakn.engine.factory.EngineGraknGraphFactory;
import ai.grakn.exception.GraknBackendException;
import ai.grakn.util.ErrorMessage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraphMutators {
    private static final Logger LOG = LoggerFactory.getLogger(GraphMutators.class);

    public static void runBatchMutationWithRetry(EngineGraknGraphFactory factory, String keyspace, int maxRetry, Consumer<GraknGraph> mutatingFunction) {
        GraphMutators.runGraphMutationWithRetry(factory, keyspace, GraknTxType.BATCH, maxRetry, mutatingFunction);
    }

    static void runGraphMutationWithRetry(EngineGraknGraphFactory factory, String keyspace, int maxRetry, Consumer<GraknGraph> mutatingFunction) {
        GraphMutators.runGraphMutationWithRetry(factory, keyspace, GraknTxType.WRITE, maxRetry, mutatingFunction);
    }

    private static void runGraphMutationWithRetry(EngineGraknGraphFactory factory, String keyspace, GraknTxType txType, int maxRetry, Consumer<GraknGraph> mutatingFunction) {
        if (!factory.systemKeyspace().containsKeyspace(keyspace)) {
            LOG.warn("Attempting to execute mutation on graph [" + keyspace + "] which no longer exists");
            return;
        }
        for (int retry = 0; retry < maxRetry; ++retry) {
            try (GraknGraph graph = factory.getGraph(keyspace, txType);){
                mutatingFunction.accept(graph);
                return;
            }
            catch (GraknBackendException e) {
                LOG.debug(ErrorMessage.GRAPH_MUTATION_ERROR.getMessage(new Object[]{e.getMessage()}), (Throwable)e);
                GraphMutators.performRetry(retry);
                continue;
            }
        }
        throw new RuntimeException(ErrorMessage.UNABLE_TO_MUTATE_GRAPH.getMessage(new Object[]{keyspace}));
    }

    private static void performRetry(int retry) {
        double seed = 1.0 + Math.random() * 5.0;
        double waitTime = (double)retry * 2.0 + seed;
        LOG.debug(ErrorMessage.BACK_OFF_RETRY.getMessage(new Object[]{waitTime}));
        try {
            Thread.sleep((long)Math.ceil(waitTime * 1000.0));
        }
        catch (InterruptedException e1) {
            LOG.error("Exception", (Throwable)e1);
        }
    }
}

