/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.postprocessing;

import ai.grakn.Grakn;
import ai.grakn.GraknComputer;
import ai.grakn.GraknGraph;
import ai.grakn.GraknSession;
import ai.grakn.GraknTxType;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Resource;
import ai.grakn.concept.Role;
import ai.grakn.engine.tasks.BackgroundTask;
import ai.grakn.exception.TemporaryWriteException;
import ai.grakn.util.Schema;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDeduplicationTask
extends BackgroundTask {
    public static final String KEYSPACE_CONFIG = "keyspace";
    public static final String KEYSPACE_DEFAULT = "grakn";
    public static final String DELETE_UNATTACHED_CONFIG = "deleteUnattached";
    public static final boolean DELETE_UNATTACHED_DEFAULT = false;
    private static final Logger LOG = LoggerFactory.getLogger(ResourceDeduplicationTask.class);
    private Long totalEliminated = null;

    static void transact(GraknSession factory, Consumer<GraknGraph> work, String description) {
        while (true) {
            try (GraknGraph graph2 = factory.open(GraknTxType.WRITE);){
                work.accept(graph2);
                return;
            }
            catch (TemporaryWriteException graph2) {
                continue;
            }
            catch (Throwable t) {
                LOG.error("ResourceDeduplicationTask, while " + description, t);
                return;
            }
            break;
        }
    }

    @Override
    public boolean start() {
        LOG.info("Starting ResourceDeduplicationTask : " + this.configuration().json());
        String keyspace = this.configuration().json().at(KEYSPACE_CONFIG, (Object)KEYSPACE_DEFAULT).asString();
        GraknComputer computer = Grakn.session((String)this.engineConfiguration().uri(), (String)keyspace).getGraphComputer();
        Job job = new Job().uri(this.engineConfiguration().uri()).keyspace(keyspace).deleteUnattached(this.configuration().json().at("deletedUnattached", (Object)false).asBoolean());
        this.totalEliminated = (Long)computer.compute((MapReduce)job).memory().get(job.getMemoryKey());
        return true;
    }

    @Override
    public boolean stop() {
        return true;
    }

    public Long totalElimintated() {
        return this.totalEliminated;
    }

    @SuppressFBWarnings(value={"CN_IMPLEMENTS_CLONE_BUT_NOT_CLONEABLE"})
    public static class Job
    implements MapReduce<String, ConceptId, String, Long, Long> {
        private boolean deleteUnattached = false;
        private String keyspace;
        private String uri;

        public Job uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Job keyspace(String keyspace) {
            this.keyspace = keyspace;
            return this;
        }

        public Job deleteUnattached(boolean deleteUnattached) {
            this.deleteUnattached = deleteUnattached;
            return this;
        }

        public boolean deleteUnattached() {
            return this.deleteUnattached;
        }

        public final void map(Vertex vertex, MapReduce.MapEmitter<String, ConceptId> emitter) {
            if (Schema.BaseType.valueOf((String)vertex.label()) != Schema.BaseType.RESOURCE) {
                return;
            }
            LOG.debug("Resource index: " + vertex.property(Schema.VertexProperty.INDEX.name()).value());
            Object key = vertex.property(Schema.VertexProperty.INDEX.name()).value();
            if (key != null) {
                LOG.debug("Emit " + key + " -- " + ConceptId.of((String)vertex.value(Schema.VertexProperty.ID.name()).toString()));
                emitter.emit((Object)key.toString(), (Object)ConceptId.of((String)vertex.value(Schema.VertexProperty.ID.name()).toString()));
            } else {
                LOG.warn("Resource " + vertex.property(Schema.VertexProperty.ID.name()) + " has no value?!");
            }
        }

        public boolean doStage(MapReduce.Stage stage) {
            return stage == MapReduce.Stage.MAP || stage == MapReduce.Stage.REDUCE;
        }

        public void reduce(String key, Iterator<ConceptId> values, MapReduce.ReduceEmitter<String, Long> emitter) {
            LOG.debug("Reduce on " + key);
            HashSet<ConceptId> conceptIds = new HashSet<ConceptId>();
            while (values.hasNext()) {
                ConceptId current = values.next();
                conceptIds.add(current);
            }
            LOG.debug("Concepts: " + conceptIds);
            if (conceptIds.size() > 1) {
                ResourceDeduplicationTask.transact(Grakn.session((String)this.uri, (String)this.keyspace), graph -> graph.admin().fixDuplicateResources(key, (Set)conceptIds), "Reducing resource duplicate set " + conceptIds);
                emitter.emit((Object)key, (Object)(conceptIds.size() - 1));
            }
            if (this.deleteUnattached) {
                try (GraknGraph graph2 = Grakn.session((String)this.uri, (String)this.keyspace).open(GraknTxType.WRITE);){
                    Resource res = (Resource)graph2.admin().getConcept(Schema.VertexProperty.INDEX, (Object)key);
                    if (res.ownerInstances().isEmpty() && res.relations(new Role[0]).isEmpty()) {
                        res.delete();
                    }
                }
            }
        }

        public String getMemoryKey() {
            return Job.class.getName();
        }

        public MapReduce<String, ConceptId, String, Long, Long> clone() {
            return this;
        }

        public Long generateFinalResult(Iterator<KeyValue<String, Long>> keyValues) {
            return (Long)IteratorUtils.reduce(keyValues, (Object)0L, (a, b) -> a + (Long)b.getValue());
        }
    }
}

