/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.postprocessing;

import ai.grakn.concept.ConceptId;
import ai.grakn.engine.factory.EngineGraknGraphFactory;
import ai.grakn.engine.postprocessing.GraphMutators;
import ai.grakn.engine.tasks.BackgroundTask;
import ai.grakn.engine.tasks.connection.RedisCountStorage;
import ai.grakn.engine.tasks.manager.TaskConfiguration;
import ai.grakn.engine.tasks.manager.TaskSchedule;
import ai.grakn.engine.tasks.manager.TaskState;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatingInstanceCountTask
extends BackgroundTask {
    private static final Logger LOG = LoggerFactory.getLogger(UpdatingInstanceCountTask.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean start() {
        long shardingThreshold = this.engineConfiguration().getPropertyAsLong("graph.sharding-threshold");
        int maxRetry = this.engineConfiguration().getPropertyAsInt("loader.repeat-commits");
        try (Timer.Context context = this.metricRegistry().timer(MetricRegistry.name(UpdatingInstanceCountTask.class, (String[])new String[]{"execution"})).time();){
            Map<ConceptId, Long> jobs = UpdatingInstanceCountTask.getCountUpdatingJobs(this.configuration());
            this.metricRegistry().histogram(MetricRegistry.name(UpdatingInstanceCountTask.class, (String[])new String[]{"jobs"})).update(jobs.size());
            String keyspace = this.configuration().json().at("keyspace").asString();
            HashSet conceptToShard = new HashSet();
            jobs.forEach((key, value) -> {
                this.metricRegistry().histogram(MetricRegistry.name(UpdatingInstanceCountTask.class, (String[])new String[]{"shard-size-increase"})).update(value.longValue());
                Timer.Context contextSingle = this.metricRegistry().timer(MetricRegistry.name(UpdatingInstanceCountTask.class, (String[])new String[]{"execution-single"})).time();
                try {
                    if (UpdatingInstanceCountTask.updateShardCounts(this.redis(), keyspace, key, value, shardingThreshold)) {
                        conceptToShard.add(key);
                    }
                }
                finally {
                    contextSingle.stop();
                }
            });
            conceptToShard.forEach(type -> {
                Timer.Context contextSharding = this.metricRegistry().timer("sharding").time();
                try {
                    this.shardConcept(this.redis(), this.factory(), keyspace, (ConceptId)type, maxRetry, shardingThreshold);
                }
                finally {
                    contextSharding.stop();
                }
            });
            LOG.debug("Updating instance count successful for {} tasks", (Object)jobs.size());
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOG.error("Could not terminate task", (Throwable)e);
            throw e;
        }
    }

    private static Map<ConceptId, Long> getCountUpdatingJobs(TaskConfiguration configuration) {
        return configuration.json().at("types-with-new-counts").asJsonList().stream().collect(Collectors.toMap(e -> ConceptId.of((String)e.at("concept-id").asString()), e -> e.at("sharding-count").asLong()));
    }

    private static boolean updateShardCounts(RedisCountStorage redis, String keyspace, ConceptId conceptId, long value, long shardingThreshold) {
        long numInstances;
        long numShards = redis.getCount(RedisCountStorage.getKeyNumShards(keyspace, conceptId));
        if (numShards == 0L) {
            numShards = 1L;
        }
        return (numInstances = redis.adjustCount(RedisCountStorage.getKeyNumInstances(keyspace, conceptId), value)) > shardingThreshold * numShards;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shardConcept(RedisCountStorage redis, EngineGraknGraphFactory factory, String keyspace, ConceptId conceptId, int maxRetry, long shardingThreshold) {
        Lock engineLock = this.getLockProvider().getLock(UpdatingInstanceCountTask.getLockingKey(keyspace, conceptId));
        engineLock.lock();
        try {
            if (UpdatingInstanceCountTask.updateShardCounts(redis, keyspace, conceptId, 0L, shardingThreshold)) {
                GraphMutators.runGraphMutationWithRetry(factory, keyspace, maxRetry, graph -> {
                    graph.admin().shard(conceptId);
                    graph.admin().commitNoLogs();
                });
                redis.adjustCount(RedisCountStorage.getKeyNumShards(keyspace, conceptId), 1L);
            }
        }
        finally {
            engineLock.unlock();
        }
    }

    private static String getLockingKey(String keyspace, ConceptId conceptId) {
        return "/updating-instance-count-lock/" + keyspace + "/" + conceptId.getValue();
    }

    public static TaskState createTask(Class creator) {
        return TaskState.of(UpdatingInstanceCountTask.class, creator.getName(), TaskSchedule.now(), TaskState.Priority.HIGH);
    }

    public static TaskConfiguration createConfig(String keyspace, String config) {
        Json countingConfiguration = Json.object();
        countingConfiguration.set("keyspace", (Object)keyspace);
        countingConfiguration.set("types-with-new-counts", Json.read((String)config).at("types-with-new-counts"));
        return TaskConfiguration.of(countingConfiguration);
    }
}

