/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.tasks.connection;

import ai.grakn.concept.ConceptId;
import java.util.function.Function;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

public class RedisCountStorage {
    private Pool<Jedis> jedisPool;

    private RedisCountStorage(Pool<Jedis> jedisPool) {
        this.jedisPool = jedisPool;
    }

    public static RedisCountStorage create(Pool<Jedis> jedisPool) {
        return new RedisCountStorage(jedisPool);
    }

    public long adjustCount(String key, long count) {
        return this.contactRedis(jedis -> {
            if (count != 0L) {
                return jedis.incrBy(key, count);
            }
            return this.getCount(key);
        });
    }

    public long getCount(String key) {
        return this.contactRedis(jedis -> {
            String value = jedis.get(key);
            if (value == null) {
                return 0L;
            }
            return Long.parseLong(value);
        });
    }

    private <X> X contactRedis(Function<Jedis, X> function) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            X x = function.apply(jedis);
            return x;
        }
    }

    public static String getKeyNumInstances(String keyspace, ConceptId conceptId) {
        return "NI_" + keyspace + "_" + conceptId.getValue();
    }

    public static String getKeyNumShards(String keyspace, ConceptId conceptId) {
        return "NS_" + keyspace + "_" + conceptId.getValue();
    }
}

