/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.tasks.manager.redisqueue;

import ai.grakn.engine.GraknEngineConfig;
import ai.grakn.engine.TaskStatus;
import ai.grakn.engine.factory.EngineGraknGraphFactory;
import ai.grakn.engine.lock.LockProvider;
import ai.grakn.engine.tasks.BackgroundTask;
import ai.grakn.engine.tasks.connection.RedisCountStorage;
import ai.grakn.engine.tasks.manager.TaskCheckpoint;
import ai.grakn.engine.tasks.manager.TaskConfiguration;
import ai.grakn.engine.tasks.manager.TaskState;
import ai.grakn.engine.tasks.manager.TaskStateStorage;
import ai.grakn.engine.tasks.manager.redisqueue.RedisTaskManager;
import ai.grakn.engine.tasks.manager.redisqueue.Task;
import ai.grakn.engine.util.EngineID;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class RedisTaskQueueConsumer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(RedisTaskQueueConsumer.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private RedisTaskManager redisTaskManager;
    private EngineID engineId;
    private GraknEngineConfig config;
    private RedisCountStorage redisCountStorage;
    private MetricRegistry metricRegistry;
    private Task task;
    private EngineGraknGraphFactory factory;
    private LockProvider lockProvider;

    public RedisTaskQueueConsumer(String taskId, TaskState taskState, TaskConfiguration taskConfiguration) {
        this.task = Task.builder().setTaskConfiguration(taskConfiguration).setTaskState(taskState).build();
    }

    public RedisTaskQueueConsumer(Task task) {
        this.task = task;
    }

    public RedisTaskQueueConsumer(Map<String, Object> task) {
        this.task = (Task)objectMapper.convertValue(task, Task.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.checkPreconditions();
        Timer executeTimer = this.metricRegistry.timer(MetricRegistry.name(RedisTaskQueueConsumer.class, (String[])new String[]{"execute"}));
        Timer.Context context = executeTimer.time();
        TaskState taskState = this.task.getTaskState();
        TaskConfiguration taskConfiguration = this.task.getTaskConfiguration();
        if (this.shouldStopTask(taskState)) {
            taskState.markStopped();
            this.redisTaskManager.storage().updateState(taskState);
            LOG.info("{}\t marked as stopped", (Object)this.task);
        } else if (this.shouldDelayTask(taskState)) {
            this.redisTaskManager.storage().updateState(taskState);
            LOG.info("{}\t resubmitted", (Object)this.task);
        } else {
            try {
                BackgroundTask runningTask = taskState.taskClass().newInstance();
                runningTask.initialize(this.saveCheckpoint(taskState, this.redisTaskManager.storage()), taskConfiguration, this.redisTaskManager, this.config, this.redisCountStorage, this.factory, this.lockProvider, this.metricRegistry);
                this.metricRegistry.meter(MetricRegistry.name(RedisTaskQueueConsumer.class, (String[])new String[]{"initialized"})).mark();
                if (this.taskShouldResume(this.task)) {
                    throw new NotImplementedException();
                }
                taskState.markRunning(this.engineId);
                this.redisTaskManager.storage().newState(taskState);
                LOG.debug("{} marked as running", (Object)this.task);
                boolean completed = runningTask.start();
                this.metricRegistry.meter(MetricRegistry.name(RedisTaskQueueConsumer.class, (String[])new String[]{"run"})).mark();
                if (completed) {
                    taskState.markCompleted();
                } else {
                    taskState.markStopped();
                }
                if (this.taskShouldRecur(taskState)) {
                    this.resubmitTask(taskState);
                }
                this.redisTaskManager.storage().updateState(taskState);
            }
            catch (Throwable throwable) {
                taskState.markFailed(throwable);
                LOG.error("{} could not be completed successfully", (Object)this.task.getTaskState().getId(), (Object)throwable);
            }
            finally {
                this.redisTaskManager.storage().updateState(taskState);
                context.stop();
            }
        }
    }

    private void checkPreconditions() {
        try {
            Preconditions.checkNotNull((Object)this.metricRegistry);
            Preconditions.checkNotNull((Object)this.engineId);
            Preconditions.checkNotNull((Object)this.config);
            Preconditions.checkNotNull((Object)this.redisCountStorage);
            Preconditions.checkNotNull((Object)this.redisTaskManager);
            Preconditions.checkNotNull((Object)this.lockProvider);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException(String.format("%s was started but the state wasn't set explicitly", this.getClass().getName()));
        }
    }

    private void resubmitTask(TaskState taskState) {
        taskState.schedule(taskState.schedule().incrementByInterval());
    }

    private boolean taskShouldRecur(TaskState taskState) {
        return taskState.schedule().isRecurring() && !taskState.status().equals((Object)TaskStatus.FAILED) && !taskState.status().equals((Object)TaskStatus.STOPPED);
    }

    private boolean shouldDelayTask(TaskState taskState) {
        return !taskState.schedule().runAt().isBefore(Instant.now());
    }

    private boolean shouldStopTask(TaskState taskState) {
        return taskState.status() == TaskStatus.STOPPED || this.redisTaskManager.storage().isTaskMarkedStopped(this.task.getTaskState().getId());
    }

    private boolean taskShouldResume(Task task) {
        return task.getTaskState().status() == TaskStatus.RUNNING;
    }

    private Consumer<TaskCheckpoint> saveCheckpoint(TaskState taskState, TaskStateStorage storage) {
        return checkpoint -> storage.updateState(taskState.checkpoint((TaskCheckpoint)checkpoint));
    }

    public void setRunningState(RedisTaskManager redisTaskManager, EngineID engineId, GraknEngineConfig config, Pool<Jedis> jedisPool, EngineGraknGraphFactory factory, LockProvider lockProvider, MetricRegistry metricRegistry) {
        this.redisTaskManager = redisTaskManager;
        this.engineId = engineId;
        this.config = config;
        this.redisCountStorage = RedisCountStorage.create(jedisPool);
        this.lockProvider = lockProvider;
        this.metricRegistry = metricRegistry;
        this.factory = factory;
    }
}

