/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.tasks.manager.redisqueue;

import ai.grakn.engine.TaskId;
import ai.grakn.engine.TaskStatus;
import ai.grakn.engine.tasks.manager.TaskState;
import ai.grakn.engine.tasks.manager.TaskStateStorage;
import ai.grakn.engine.util.EngineID;
import ai.grakn.exception.GraknBackendException;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Base64;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

public class RedisTaskStorage
implements TaskStateStorage {
    private static final Logger LOG = LoggerFactory.getLogger(RedisTaskStorage.class);
    private final Timer updateTimer;
    private final Timer getTimer;
    private Pool<Jedis> redis;

    private RedisTaskStorage(Pool<Jedis> redis, MetricRegistry metricRegistry) {
        this.redis = redis;
        this.updateTimer = metricRegistry.timer(MetricRegistry.name(RedisTaskStorage.class, (String[])new String[]{"update"}));
        this.getTimer = metricRegistry.timer(MetricRegistry.name(RedisTaskStorage.class, (String[])new String[]{"get"}));
    }

    public static RedisTaskStorage create(Pool<Jedis> jedisPool, MetricRegistry metricRegistry) {
        return new RedisTaskStorage(jedisPool, metricRegistry);
    }

    @Override
    public TaskId newState(TaskState state) throws GraknBackendException {
        this.updateState(state);
        return state.getId();
    }

    /*
     * Exception decompiling
     */
    @Override
    public Boolean updateState(TaskState state) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @Nullable
    public TaskState getState(TaskId id) throws GraknBackendException {
        Throwable throwable = null;
        try (Jedis jedis = (Jedis)this.redis.getResource();){
            Throwable throwable2;
            Timer.Context ignore;
            block25: {
                TaskState taskState;
                block26: {
                    block27: {
                        ignore = this.getTimer.time();
                        throwable2 = null;
                        String value = jedis.get(id.getValue());
                        if (value == null) break block25;
                        taskState = (TaskState)SerializationUtils.deserialize((byte[])Base64.getDecoder().decode(value));
                        if (ignore == null) break block26;
                        if (throwable2 == null) break block27;
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block26;
                    }
                    ignore.close();
                }
                return taskState;
            }
            try {
                try {
                    try {
                        LOG.info("Requested state {} was not found", (Object)id.getValue());
                        throw GraknBackendException.stateStorageMissingId((TaskId)id);
                    }
                    catch (Throwable throwable4) {
                        throwable2 = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (ignore != null) {
                        if (throwable2 != null) {
                            try {
                                ignore.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            ignore.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
    }

    @Override
    public boolean containsTask(TaskId id) {
        try (Jedis jedis = (Jedis)this.redis.getResource();){
            String value = jedis.get(id.getValue());
            boolean bl = value != null;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<TaskState> getTasks(TaskStatus taskStatus, String taskClassName, String createdBy, EngineID runningOnEngine, int limit, int offset) {
        try (Jedis jedis = (Jedis)this.redis.getResource();){
            Stream<TaskState> stream = jedis.keys("*-*-*-*").stream().map(value -> (TaskState)SerializationUtils.deserialize((byte[])Base64.getDecoder().decode((String)value)));
            if (taskStatus != null) {
                stream = stream.filter(t -> t.status().equals((Object)taskStatus));
            }
            if (taskClassName != null) {
                stream = stream.filter(t -> t.taskClass().getName().equals(taskClassName));
            }
            if (createdBy != null) {
                stream = stream.filter(t -> t.creator().equals(createdBy));
            }
            if (runningOnEngine != null) {
                stream = stream.filter(t -> t.engineID() != null && t.engineID().equals(runningOnEngine));
            }
            stream = stream.skip(offset);
            if (limit > 0) {
                stream = stream.limit(limit);
            }
            Set<TaskState> set = stream.collect(Collectors.toSet());
            return set;
        }
        catch (Exception e) {
            throw GraknBackendException.stateStorageTaskRetrievalFailure((Exception)e);
        }
    }

    boolean isTaskMarkedStopped(TaskId id) {
        try {
            TaskState state = this.getState(id);
            return state != null && state.getStatus().equals((Object)TaskStatus.STOPPED);
        }
        catch (GraknBackendException e) {
            return false;
        }
    }
}

