/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.tasks.mock;

import ai.grakn.engine.TaskId;
import ai.grakn.engine.tasks.BackgroundTask;
import ai.grakn.engine.tasks.manager.TaskCheckpoint;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.ImmutableMultiset;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public abstract class MockBackgroundTask
extends BackgroundTask {
    private static final ConcurrentHashMultiset<TaskId> COMPLETED_TASKS = ConcurrentHashMultiset.create();
    private static final ConcurrentHashMultiset<TaskId> CANCELLED_TASKS = ConcurrentHashMultiset.create();
    private static Consumer<TaskId> onTaskStart;
    private static Consumer<TaskId> onTaskFinish;
    private static Consumer<TaskCheckpoint> onTaskResume;
    protected final AtomicBoolean cancelled = new AtomicBoolean(false);
    protected final Object sync = new Object();
    private TaskId id;

    private static void addCompletedTask(TaskId taskId) {
        COMPLETED_TASKS.add((Object)taskId);
    }

    public static ImmutableMultiset<TaskId> completedTasks() {
        return ImmutableMultiset.copyOf(COMPLETED_TASKS);
    }

    private static void addCancelledTask(TaskId taskId) {
        CANCELLED_TASKS.add((Object)taskId);
    }

    public static ImmutableMultiset<TaskId> cancelledTasks() {
        return ImmutableMultiset.copyOf(CANCELLED_TASKS);
    }

    public static void whenTaskStarts(Consumer<TaskId> beforeTaskStarts) {
        onTaskStart = beforeTaskStarts;
    }

    private static void onTaskStart(TaskId taskId) {
        if (onTaskStart != null) {
            onTaskStart.accept(taskId);
        }
    }

    public static void whenTaskFinishes(Consumer<TaskId> onTaskFinish) {
        MockBackgroundTask.onTaskFinish = onTaskFinish;
    }

    private static void onTaskFinish(TaskId taskId) {
        if (onTaskFinish != null) {
            onTaskFinish.accept(taskId);
        }
    }

    public static void whenTaskResumes(Consumer<TaskCheckpoint> onTaskResume) {
        MockBackgroundTask.onTaskResume = onTaskResume;
    }

    private static void onTaskResume(TaskCheckpoint checkpoint) {
        if (onTaskResume != null) {
            onTaskResume.accept(checkpoint);
        }
    }

    public static void clearTasks() {
        COMPLETED_TASKS.clear();
        CANCELLED_TASKS.clear();
        onTaskStart = null;
        onTaskFinish = null;
        onTaskResume = null;
    }

    @Override
    public final boolean start() {
        this.id = TaskId.of((String)this.configuration().json().at("id").asString());
        MockBackgroundTask.onTaskStart(this.id);
        this.saveCheckpoint(TaskCheckpoint.of(this.configuration().json()));
        boolean wasCancelled = this.cancelled.get();
        if (!wasCancelled) {
            this.executeStartInner(this.id);
        }
        if (!(wasCancelled = this.cancelled.get())) {
            MockBackgroundTask.addCompletedTask(this.id);
        } else {
            MockBackgroundTask.addCancelledTask(this.id);
        }
        MockBackgroundTask.onTaskFinish(this.id);
        return !wasCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean stop() {
        this.cancelled.set(true);
        Object object = this.sync;
        synchronized (object) {
            this.sync.notifyAll();
        }
        return true;
    }

    @Override
    public final boolean resume(TaskCheckpoint lastCheckpoint) {
        MockBackgroundTask.onTaskResume(lastCheckpoint);
        this.executeResumeInner(lastCheckpoint);
        return true;
    }

    protected abstract void executeStartInner(TaskId var1);

    protected abstract void executeResumeInner(TaskCheckpoint var1);
}

