/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine;

import ai.grakn.engine.GraknEngineConfig;
import ai.grakn.engine.GraknEngineStatus;
import ai.grakn.engine.controller.AuthController;
import ai.grakn.engine.controller.CommitLogController;
import ai.grakn.engine.controller.ConceptController;
import ai.grakn.engine.controller.DashboardController;
import ai.grakn.engine.controller.GraqlController;
import ai.grakn.engine.controller.SystemController;
import ai.grakn.engine.controller.TasksController;
import ai.grakn.engine.controller.UserController;
import ai.grakn.engine.controller.api.AttributeController;
import ai.grakn.engine.controller.api.AttributeTypeController;
import ai.grakn.engine.controller.api.EntityController;
import ai.grakn.engine.controller.api.EntityTypeController;
import ai.grakn.engine.controller.api.RelationshipController;
import ai.grakn.engine.controller.api.RelationshipTypeController;
import ai.grakn.engine.controller.api.RoleController;
import ai.grakn.engine.controller.api.RuleController;
import ai.grakn.engine.data.RedisWrapper;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import ai.grakn.engine.lock.JedisLockProvider;
import ai.grakn.engine.lock.LockProvider;
import ai.grakn.engine.lock.ProcessWideLockProvider;
import ai.grakn.engine.session.RemoteSession;
import ai.grakn.engine.tasks.connection.RedisCountStorage;
import ai.grakn.engine.tasks.manager.StandaloneTaskManager;
import ai.grakn.engine.tasks.manager.TaskManager;
import ai.grakn.engine.tasks.manager.redisqueue.RedisTaskManager;
import ai.grakn.engine.user.UsersHandler;
import ai.grakn.engine.util.EngineID;
import ai.grakn.engine.util.JWTHandler;
import ai.grakn.exception.GraknBackendException;
import ai.grakn.exception.GraknServerException;
import ai.grakn.util.ErrorMessage;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.CachedThreadStatesGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.google.common.base.Stopwatch;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nullable;
import mjson.Json;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.Service;

public class GraknEngineServer
implements AutoCloseable {
    private static final String REDIS_VERSION_KEY = "info:version";
    private static final String LOAD_SYSTEM_SCHEMA_LOCK_NAME = "load-system-schema";
    private static final Logger LOG = LoggerFactory.getLogger(GraknEngineServer.class);
    private static final Set<String> unauthenticatedEndPoints = new HashSet<String>(Arrays.asList("/auth/session/", "/shell/remote", "/configuration", "/auth/enabled/"));
    private final GraknEngineConfig prop;
    private final EngineID engineId = EngineID.me();
    private final Service spark = Service.ignite();
    private final TaskManager taskManager;
    private final EngineGraknTxFactory factory;
    private final MetricRegistry metricRegistry;
    private final LockProvider lockProvider;
    private final GraknEngineStatus graknEngineStatus = new GraknEngineStatus();
    private final RedisWrapper redisWrapper;

    private GraknEngineServer(GraknEngineConfig prop, RedisWrapper redisWrapper) {
        this.prop = prop;
        this.metricRegistry = new MetricRegistry();
        this.redisWrapper = redisWrapper;
        String taskManagerClassName = prop.getProperty("taskmanager.implementation");
        boolean inMemoryQueue = !taskManagerClassName.contains("RedisTaskManager");
        this.lockProvider = inMemoryQueue ? new ProcessWideLockProvider() : new JedisLockProvider(redisWrapper.getJedisPool());
        this.factory = EngineGraknTxFactory.create(prop.getProperties());
        this.taskManager = this.makeTaskManager(inMemoryQueue, redisWrapper.getJedisPool(), this.lockProvider);
    }

    public static GraknEngineServer create(GraknEngineConfig prop) {
        return GraknEngineServer.create(prop, GraknEngineServer.instantiateRedis(prop));
    }

    public static GraknEngineServer create(GraknEngineConfig prop, RedisWrapper redisWrapper) {
        return new GraknEngineServer(prop, redisWrapper);
    }

    public static void main(String[] args) {
        try {
            GraknEngineConfig prop = GraknEngineConfig.create();
            GraknEngineServer graknEngineServer = GraknEngineServer.create(prop);
            graknEngineServer.start();
            Thread closeThread = new Thread(graknEngineServer::close, "GraknEngineServer-shutdown");
            Runtime.getRuntime().addShutdownHook(closeThread);
        }
        catch (Exception e) {
            LOG.error("An exception has occurred", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.redisWrapper.testConnection();
        LOG.info("Starting task manager {}", (Object)this.taskManager.getClass().getCanonicalName());
        this.taskManager.start();
        Stopwatch timer = Stopwatch.createStarted();
        this.logStartMessage(this.prop.getProperty("server.host"), this.prop.getProperty("server.port"));
        GraknEngineServer graknEngineServer = this;
        synchronized (graknEngineServer) {
            this.checkVersion();
            this.lockAndInitializeSystemSchema();
            this.startHTTP();
        }
        this.graknEngineStatus.setReady(true);
        LOG.info("Grakn started in {}", (Object)timer.stop());
    }

    private void checkVersion() {
        Jedis jedis = (Jedis)this.redisWrapper.getJedisPool().getResource();
        String storedVersion = jedis.get(REDIS_VERSION_KEY);
        if (storedVersion == null) {
            jedis.set(REDIS_VERSION_KEY, "0.17.0");
        } else if (!storedVersion.equals("0.17.0")) {
            LOG.warn(ErrorMessage.VERSION_MISMATCH.getMessage(new Object[]{"0.17.0", storedVersion}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        GraknEngineServer graknEngineServer = this;
        synchronized (graknEngineServer) {
            this.stopTaskManager();
            this.stopHTTP();
            this.redisWrapper.close();
        }
    }

    private void lockAndInitializeSystemSchema() {
        try {
            Lock lock = this.lockProvider.getLock(LOAD_SYSTEM_SCHEMA_LOCK_NAME);
            if (lock.tryLock(60L, TimeUnit.SECONDS)) {
                this.loadAndUnlock(lock);
            } else {
                LOG.info("{} found system schema lock already acquired by other engine", (Object)this.engineId);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("{} was interrupted while initializing system schema", (Object)this.engineId);
        }
    }

    private void loadAndUnlock(Lock lock) {
        try {
            LOG.info("{} is checking the system schema", (Object)this.engineId);
            this.factory.systemKeyspace().loadSystemSchema();
        }
        finally {
            lock.unlock();
        }
    }

    private TaskManager makeTaskManager(boolean inMemoryQueue, Pool<Jedis> jedisPool, LockProvider lockProvider) {
        TaskManager taskManager;
        this.metricRegistry.register(MetricRegistry.name(GraknEngineServer.class, (String[])new String[]{"jedis", "idle"}), (Metric)((Gauge)() -> jedisPool.getNumIdle()));
        this.metricRegistry.register(MetricRegistry.name(GraknEngineServer.class, (String[])new String[]{"jedis", "active"}), (Metric)((Gauge)() -> jedisPool.getNumActive()));
        this.metricRegistry.register(MetricRegistry.name(GraknEngineServer.class, (String[])new String[]{"jedis", "waiters"}), (Metric)((Gauge)() -> jedisPool.getNumWaiters()));
        this.metricRegistry.register(MetricRegistry.name(GraknEngineServer.class, (String[])new String[]{"jedis", "borrow_wait_time_ms", "max"}), (Metric)((Gauge)() -> jedisPool.getMaxBorrowWaitTimeMillis()));
        this.metricRegistry.register(MetricRegistry.name(GraknEngineServer.class, (String[])new String[]{"jedis", "borrow_wait_time_ms", "mean"}), (Metric)((Gauge)() -> jedisPool.getMeanBorrowWaitTimeMillis()));
        this.metricRegistry.register(MetricRegistry.name(GraknEngineServer.class, (String[])new String[]{"System", "gc"}), (Metric)new GarbageCollectorMetricSet());
        this.metricRegistry.register(MetricRegistry.name(GraknEngineServer.class, (String[])new String[]{"System", "threads"}), (Metric)new CachedThreadStatesGaugeSet(15L, TimeUnit.SECONDS));
        this.metricRegistry.register(MetricRegistry.name(GraknEngineServer.class, (String[])new String[]{"System", "memory"}), (Metric)new MemoryUsageGaugeSet());
        if (!inMemoryQueue) {
            Optional<String> consumers = this.prop.tryProperty("queue.consumers");
            taskManager = consumers.map(s -> new RedisTaskManager(this.engineId, this.prop, jedisPool, Integer.parseInt(s), this.factory, lockProvider, this.metricRegistry)).orElseGet(() -> new RedisTaskManager(this.engineId, this.prop, jedisPool, this.factory, lockProvider, this.metricRegistry));
        } else {
            LOG.info("Task queue in memory");
            RedisCountStorage redisCountStorage = RedisCountStorage.create(jedisPool, this.metricRegistry);
            taskManager = new StandaloneTaskManager(this.engineId, this.prop, redisCountStorage, this.factory, lockProvider, this.metricRegistry);
        }
        return taskManager;
    }

    public void startHTTP() {
        boolean passwordProtected = this.prop.getPropertyAsBool("password.protected", false);
        Optional<String> secret = this.prop.tryProperty("JWT.secret");
        JWTHandler jwtHandler = secret.map(JWTHandler::create).orElse(null);
        UsersHandler usersHandler = UsersHandler.create(this.prop.getProperty("admin.password"), this.factory);
        GraknEngineServer.configureSpark(this.spark, this.prop, jwtHandler);
        RemoteSession graqlWebSocket = passwordProtected ? RemoteSession.passwordProtected(usersHandler) : RemoteSession.create();
        this.spark.webSocket("/shell/remote", (Object)graqlWebSocket);
        int postProcessingDelay = this.prop.getPropertyAsInt("tasks.postprocessing.delay");
        new GraqlController(this.factory, this.spark, this.metricRegistry);
        new ConceptController(this.factory, this.spark, this.metricRegistry);
        new DashboardController(this.factory, this.spark);
        new SystemController(this.factory, this.spark, this.graknEngineStatus, this.metricRegistry);
        new AuthController(this.spark, passwordProtected, jwtHandler, usersHandler);
        new UserController(this.spark, usersHandler);
        new CommitLogController(this.spark, postProcessingDelay, this.taskManager);
        new TasksController(this.spark, this.taskManager, this.metricRegistry);
        new EntityController(this.factory, this.spark);
        new EntityTypeController(this.factory, this.spark);
        new RelationshipController(this.factory, this.spark);
        new RelationshipTypeController(this.factory, this.spark);
        new AttributeController(this.factory, this.spark);
        new AttributeTypeController(this.factory, this.spark);
        new RoleController(this.factory, this.spark);
        new RuleController(this.factory, this.spark);
        this.spark.awaitInitialization();
    }

    public static void configureSpark(Service spark, GraknEngineConfig prop, @Nullable JWTHandler jwtHandler) {
        GraknEngineServer.configureSpark(spark, prop.getProperty("server.host"), Integer.parseInt(prop.getProperty("server.port")), prop.getPath("server.static-file-dir"), prop.getPropertyAsBool("password.protected", false), prop.tryIntProperty("webserver.threads", 64), jwtHandler);
    }

    public static void configureSpark(Service spark, String hostName, int port, String staticFolder, boolean passwordProtected, int maxThreads, @Nullable JWTHandler jwtHandler) {
        spark.ipAddress(hostName);
        spark.port(port);
        spark.staticFiles.externalLocation(staticFolder);
        spark.threadPool(maxThreads);
        spark.webSocketIdleTimeoutMillis(3600000);
        if (passwordProtected) {
            spark.before((req, res) -> GraknEngineServer.checkAuthorization(spark, req, jwtHandler));
        }
        spark.exception(GraknServerException.class, (e, req, res) -> {
            assert (e instanceof GraknServerException);
            GraknEngineServer.handleGraknServerError((GraknServerException)e, res);
        });
        spark.exception(Exception.class, (e, req, res) -> GraknEngineServer.handleInternalError(e, res));
    }

    public void stopHTTP() {
        this.spark.stop();
        boolean running = true;
        while (running) {
            try {
                this.spark.port();
            }
            catch (IllegalStateException e) {
                LOG.debug("Spark server has been stopped");
                running = false;
            }
        }
    }

    private void stopTaskManager() {
        try {
            this.taskManager.close();
        }
        catch (Exception e) {
            LOG.error(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public EngineGraknTxFactory factory() {
        return this.factory;
    }

    public GraknEngineStatus getGraknEngineStatus() {
        return this.graknEngineStatus;
    }

    private static void checkAuthorization(Service spark, Request request, JWTHandler jwtHandler) throws HaltException {
        if (!unauthenticatedEndPoints.contains(request.pathInfo())) {
            boolean authenticated;
            try {
                if (request.headers("Authorization") == null || !request.headers("Authorization").startsWith("Bearer ")) {
                    throw GraknServerException.authenticationFailure();
                }
                String token = request.headers("Authorization").substring(7);
                authenticated = jwtHandler.verifyJWT(token);
                request.attribute("user", (Object)jwtHandler.extractUserFromJWT(token));
            }
            catch (GraknBackendException e) {
                throw e;
            }
            catch (Exception e) {
                throw GraknServerException.serverException((int)400, (Exception)e);
            }
            if (!authenticated) {
                throw spark.halt(401, "User not authenticated.");
            }
        }
    }

    private static void handleGraknServerError(GraknServerException exception, Response response) {
        LOG.error("REST error", (Throwable)exception);
        response.status(exception.getStatus());
        response.body(Json.object((Object[])new Object[]{"exception", exception.getMessage()}).toString());
        response.type(ContentType.APPLICATION_JSON.getMimeType());
    }

    private static void handleInternalError(Exception exception, Response response) {
        LOG.error("REST error", (Throwable)exception);
        response.status(500);
        response.body(Json.object((Object[])new Object[]{"exception", exception.getMessage()}).toString());
        response.type(ContentType.APPLICATION_JSON.getMimeType());
    }

    private static RedisWrapper instantiateRedis(GraknEngineConfig prop) {
        List<String> redisUrl = GraknEngineConfig.parseCSValue(prop.tryProperty("queue.host").orElse("localhost:6379"));
        List<String> sentinelUrl = GraknEngineConfig.parseCSValue(prop.tryProperty("redis.sentinel.host").orElse(""));
        int poolSize = prop.tryIntProperty("redis.pool-size", 32);
        boolean useSentinel = !sentinelUrl.isEmpty();
        RedisWrapper.Builder builder = RedisWrapper.builder().setUseSentinel(useSentinel).setPoolSize(poolSize).setURI(useSentinel ? sentinelUrl : redisUrl);
        if (useSentinel) {
            builder.setMasterName(prop.tryProperty("redis.sentinel.master").orElse("graknmaster"));
        }
        return builder.build();
    }

    private void logStartMessage(String host, String port) {
        String address = "http://" + host + ":" + port;
        LOG.info("\n==================================================");
        LOG.info("\n" + String.format("     ___  ___  ___  _  __ _  _     ___  ___     %n    / __|| _ \\/   \\| |/ /| \\| |   /   \\|_ _|    %n   | (_ ||   /| - || ' < | .` | _ | - | | |     %n    \\___||_|_\\|_|_||_|\\_\\|_|\\_|(_)|_|_||___|   %n%n Web Dashboard available at [%s]", address));
        LOG.info("\n==================================================");
    }
}

