/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine;

import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.Thing;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import ai.grakn.exception.GraknBackendException;
import ai.grakn.exception.InvalidKBException;
import com.google.common.base.Stopwatch;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemKeyspace {
    public static final Keyspace SYSTEM_KB_KEYSPACE = Keyspace.of((String)"graknsystem");
    public static final Label KEYSPACE_ENTITY = Label.of((String)"keyspace");
    public static final Label KEYSPACE_RESOURCE = Label.of((String)"keyspace-name");
    private static final Logger LOG = LoggerFactory.getLogger(SystemKeyspace.class);
    private final ConcurrentHashMap<Keyspace, Boolean> openSpaces;
    private final EngineGraknTxFactory factory;

    public SystemKeyspace(EngineGraknTxFactory factory) {
        this(factory, true);
    }

    public SystemKeyspace(EngineGraknTxFactory factory, boolean loadSystemSchema) {
        this.factory = factory;
        this.openSpaces = new ConcurrentHashMap();
        if (loadSystemSchema) {
            this.loadSystemSchema();
        }
    }

    public boolean ensureKeyspaceInitialised(Keyspace keyspace) {
        if (this.openSpaces.containsKey(keyspace)) {
            return true;
        }
        try (GraknTx graph = this.factory.tx(SYSTEM_KB_KEYSPACE, GraknTxType.WRITE);){
            AttributeType keyspaceName = (AttributeType)graph.getSchemaConcept(KEYSPACE_RESOURCE);
            if (keyspaceName == null) {
                throw GraknBackendException.initializationException((Keyspace)keyspace);
            }
            Attribute attribute = keyspaceName.putAttribute((Object)keyspace.getValue());
            if (attribute.owner() == null) {
                ((EntityType)graph.getSchemaConcept(KEYSPACE_ENTITY)).addEntity().attribute(attribute);
            }
            graph.admin().commitNoLogs();
        }
        catch (InvalidKBException e) {
            throw new RuntimeException("Could not add keyspace [" + keyspace + "] to system graph", e);
        }
        return true;
    }

    public boolean containsKeyspace(Keyspace keyspace) {
        try (GraknTx graph = this.factory.tx(SYSTEM_KB_KEYSPACE, GraknTxType.READ);){
            boolean bl = graph.getAttributeType(KEYSPACE_RESOURCE.getValue()).getAttribute((Object)keyspace) != null;
            return bl;
        }
    }

    public boolean deleteKeyspace(Keyspace keyspace) {
        if (keyspace.equals(SYSTEM_KB_KEYSPACE)) {
            return false;
        }
        try (GraknTx graph = this.factory.tx(SYSTEM_KB_KEYSPACE, GraknTxType.WRITE);){
            AttributeType keyspaceName = (AttributeType)graph.getSchemaConcept(KEYSPACE_RESOURCE);
            Attribute attribute = keyspaceName.getAttribute((Object)keyspace.getValue());
            if (attribute == null) {
                boolean bl = false;
                return bl;
            }
            Thing thing = attribute.owner();
            if (thing != null) {
                thing.delete();
            }
            attribute.delete();
            this.openSpaces.remove(keyspace);
            graph.admin().commitNoLogs();
        }
        return true;
    }

    public void loadSystemSchema() {
        Stopwatch timer = Stopwatch.createStarted();
        try (GraknTx tx = this.factory.tx(SYSTEM_KB_KEYSPACE, GraknTxType.WRITE);){
            if (tx.getSchemaConcept(KEYSPACE_ENTITY) != null) {
                return;
            }
            LOG.info("Loading schema");
            this.loadSystemSchema(tx);
            tx.admin().commitNoLogs();
            LOG.info("Loaded system schema to system keyspace. Took: {}", (Object)timer.stop());
        }
        catch (Exception e) {
            LOG.error("Error while loading system schema in {}. The error was: {}", new Object[]{timer.stop(), e.getMessage(), e});
            throw e;
        }
    }

    private void loadSystemSchema(GraknTx tx) {
        AttributeType keyspaceName = tx.putAttributeType("keyspace-name", AttributeType.DataType.STRING);
        tx.putEntityType("keyspace").key(keyspaceName);
        AttributeType userName = tx.putAttributeType("user-name", AttributeType.DataType.STRING);
        AttributeType userPassword = tx.putAttributeType("user-password", AttributeType.DataType.STRING);
        AttributeType userPasswordSalt = tx.putAttributeType("user-password-salt", AttributeType.DataType.STRING);
        AttributeType userFirstName = tx.putAttributeType("user-first-name", AttributeType.DataType.STRING);
        AttributeType userLastName = tx.putAttributeType("user-last-name", AttributeType.DataType.STRING);
        AttributeType userEmail = tx.putAttributeType("user-email", AttributeType.DataType.STRING);
        AttributeType userIsAdmin = tx.putAttributeType("user-is-admin", AttributeType.DataType.BOOLEAN);
        tx.putEntityType("user").key(userName).attribute(userPassword).attribute(userPasswordSalt).attribute(userFirstName).attribute(userLastName).attribute(userEmail).attribute(userIsAdmin);
    }
}

