/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.engine.user.UsersHandler;
import ai.grakn.engine.util.JWTHandler;
import ai.grakn.exception.GraknServerException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import mjson.Json;
import spark.Request;
import spark.Response;
import spark.Service;

@Path(value="/auth")
@Api(value="/graph", description="Endpoints used to handle operations related to authentication.")
@Produces(value={"application/json", "text/plain"})
public class AuthController {
    private static final String USERNAME_KEY = "username";
    private static final String PASSWORD_KEY = "password";
    private final UsersHandler usersHandler;
    private final JWTHandler jwtHandler;
    private boolean isPasswordProtected;

    public AuthController(Service spark, boolean isPasswordProtected, JWTHandler jwtHandler, UsersHandler usersHandler) {
        this.isPasswordProtected = isPasswordProtected;
        this.usersHandler = usersHandler;
        this.jwtHandler = jwtHandler;
        spark.post("/auth/session/", this::newSession);
        spark.get("/auth/enabled/", this::isPasswordProtected);
    }

    @POST
    @Path(value="/session")
    @ApiOperation(value="If a given user/password pair is valid, returns a new JWT")
    @ApiImplicitParams(value={@ApiImplicitParam(name="username", value="Username", required=true, dataType="string", paramType="body"), @ApiImplicitParam(name="password", value="Password", required=true, dataType="string", paramType="body")})
    private String newSession(Request req, Response res) {
        String password;
        String user;
        try {
            Json jsonBody = Json.read((String)req.body());
            user = jsonBody.at(USERNAME_KEY).asString();
            password = jsonBody.at(PASSWORD_KEY).asString();
        }
        catch (Exception e) {
            throw GraknServerException.serverException((int)400, (Exception)e);
        }
        if (this.usersHandler.validateUser(user, password)) {
            return this.jwtHandler.signJWT(user);
        }
        throw GraknServerException.authenticationFailure();
    }

    @GET
    @Path(value="/enabled")
    @ApiOperation(value="Returns true if Engine endpoints are password protected. False otherwise.")
    private boolean isPasswordProtected(Request req, Response res) {
        return this.isPasswordProtected;
    }
}

