/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.Keyspace;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import ai.grakn.exception.GraknServerException;
import ai.grakn.exception.GraknTxOperationException;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.exception.GraqlSyntaxException;
import ai.grakn.exception.InvalidKBException;
import ai.grakn.graql.AggregateQuery;
import ai.grakn.graql.ComputeQuery;
import ai.grakn.graql.GetQuery;
import ai.grakn.graql.Printer;
import ai.grakn.graql.Query;
import ai.grakn.graql.analytics.PathQuery;
import ai.grakn.graql.internal.hal.HALBuilder;
import ai.grakn.graql.internal.printer.Printers;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import mjson.Json;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Service;

@Path(value="/graph/graql")
@Api(value="/graph/graql", description="Endpoints used to query the graph by ID or Graql get query and build HAL objects.")
@Produces(value={"application/json", "text/plain"})
public class GraqlController {
    private static final Logger LOG = LoggerFactory.getLogger(GraqlController.class);
    private final EngineGraknTxFactory factory;
    private final Timer executeGraqlGetTimer;
    private final Timer executeGraqlPostTimer;

    public GraqlController(EngineGraknTxFactory factory, Service spark, MetricRegistry metricRegistry) {
        this.factory = factory;
        this.executeGraqlGetTimer = metricRegistry.timer(MetricRegistry.name(GraqlController.class, (String[])new String[]{"execute-graql-get"}));
        this.executeGraqlPostTimer = metricRegistry.timer(MetricRegistry.name(GraqlController.class, (String[])new String[]{"execute-graql-post"}));
        spark.post("/kb/graql/execute", this::executeGraql);
        spark.get("/kb/graql", this::executeGraqlGET);
        spark.exception(GraqlQueryException.class, (e, req, res) -> GraqlController.handleError(400, e, res));
        spark.exception(GraqlSyntaxException.class, (e, req, res) -> GraqlController.handleError(400, e, res));
        spark.exception(GraknTxOperationException.class, (e, req, res) -> GraqlController.handleError(422, e, res));
        spark.exception(InvalidKBException.class, (e, req, res) -> GraqlController.handleError(422, e, res));
    }

    /*
     * Exception decompiling
     */
    @POST
    @Path(value="/execute")
    @ApiOperation(value="Execute an arbitrary Graql queryEndpoints used to query the graph by ID or Graql get query and build HAL objects.")
    private Object executeGraql(Request request, Response response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @GET
    @Path(value="/")
    @ApiOperation(value="Executes graql query on the server and build a representation for each concept in the query result. Return type is determined by the provided accept type: application/graql+json, application/hal+json or application/text")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyspace", value="Name of graph to use", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="query", value="Get query to execute", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="infer", value="Should reasoner with the current query.", required=true, dataType="boolean", paramType="query"), @ApiImplicitParam(name="materialise", value="Should reasoner materialise results with the current query.", required=true, dataType="boolean", paramType="query")})
    private Object executeGraqlGET(Request request, Response response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void handleError(int status, Exception exception, Response response) {
        LOG.error("REST error", (Throwable)exception);
        response.status(status);
        response.body(Json.object((Object[])new Object[]{"exception", exception.getMessage()}).toString());
        response.type(ContentType.APPLICATION_JSON.getMimeType());
    }

    private boolean validContentType(String acceptType, Query<?> query) {
        if (query instanceof ComputeQuery && !(query instanceof PathQuery) && acceptType.equals("application/hal+json")) {
            return false;
        }
        return !(query instanceof AggregateQuery) || !acceptType.equals("application/hal+json");
    }

    private Object respond(Response response, String contentType, Object responseBody) {
        response.type(contentType);
        response.body(responseBody.toString());
        response.status(200);
        return responseBody;
    }

    private Object executeQuery(Keyspace keyspace, int limitEmbedded, Query<?> query, String acceptType) {
        Printer printer;
        switch (acceptType) {
            case "application/text": {
                printer = Printers.graql((boolean)false, (AttributeType[])new AttributeType[0]);
                break;
            }
            case "application/graql+json": {
                printer = Printers.json();
                break;
            }
            case "application/hal+json": {
                printer = Printers.hal((Keyspace)keyspace, (int)limitEmbedded);
                break;
            }
            default: {
                throw GraknServerException.unsupportedContentType((String)acceptType);
            }
        }
        String formatted = printer.graqlString(query.execute());
        return acceptType.equals("application/text") ? formatted : Json.read((String)formatted);
    }

    static String getAcceptType(Request request) {
        String header = request.headers("Accept");
        return header == null ? "" : request.headers("Accept").split(",")[0];
    }

    private Object executeGET(Keyspace keyspace, int limitEmbedded, Query<?> query, String acceptType) {
        switch (acceptType) {
            case "application/text": {
                return this.formatGETAsGraql(Printers.graql((boolean)false, (AttributeType[])new AttributeType[0]), query);
            }
            case "application/graql+json": {
                return this.formatGETAsGraql(Printers.json(), query);
            }
            case "application/hal+json": {
                return this.formatGETAsHAL(query, keyspace, limitEmbedded);
            }
        }
        throw GraknServerException.unsupportedContentType((String)acceptType);
    }

    private Json formatGETAsHAL(Query<?> query, Keyspace keyspace, int numberEmbeddedComponents) {
        if (query instanceof GetQuery) {
            return HALBuilder.renderHALArrayData((GetQuery)((GetQuery)query), (int)0, (int)numberEmbeddedComponents);
        }
        if (query instanceof PathQuery) {
            Json array = Json.array();
            ((List)((PathQuery)query).execute().orElse(new ArrayList())).forEach(c -> array.add(Json.read((String)HALBuilder.renderHALConceptData((Concept)c, (int)0, (Keyspace)keyspace, (int)0, (int)numberEmbeddedComponents))));
            return array;
        }
        throw new RuntimeException("Unsupported query type in HAL formatter");
    }

    private Object formatGETAsGraql(Printer printer, Query<?> query) {
        return printer.graqlString(query.execute());
    }
}

