/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.engine.user.UsersHandler;
import ai.grakn.exception.GraknServerException;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Service;

@Path(value="/user")
@Produces(value={"application/json", "text/plain"})
public class UserController {
    private final Logger LOG = LoggerFactory.getLogger(UserController.class);
    private final UsersHandler users;

    public UserController(Service spark, UsersHandler usersHandler) {
        this.users = usersHandler;
        spark.get("/user/all", this::findUsers);
        spark.get("/user/one/:user-name", this::getUser);
        spark.post("/user/one", this::createUser);
        spark.delete("/user/one/:user-name", this::removeUser);
        spark.put("/user/one", this::updateUser);
    }

    @GET
    @Path(value="/all")
    @ApiOperation(value="Get users.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="limit", value="Limit the number of users returned.", dataType="int", paramType="query"), @ApiImplicitParam(name="offset", value="Start results from the given offset.", dataType="int", paramType="query")})
    private Json findUsers(Request request, Response response) {
        try {
            int limit = !request.params().containsKey("limit") ? Integer.MAX_VALUE : Integer.parseInt((String)request.params().get("limit"));
            int offset = !request.params().containsKey("offset") ? Integer.MAX_VALUE : Integer.parseInt((String)request.params().get("offset"));
            return this.users.allUsers(offset, limit);
        }
        catch (NumberFormatException ex) {
            response.status(400);
            return Json.nil();
        }
    }

    @GET
    @Path(value="/one/:user-name")
    @ApiOperation(value="Get one user.")
    @ApiImplicitParam(name="user-name", value="Username of user.", required=true, dataType="string", paramType="path")
    private Json getUser(Request request, Response response) {
        Json result = this.users.getUser(request.params("user-name"));
        if (result.isNull()) {
            response.status(404);
        }
        return result;
    }

    @POST
    @Path(value="/one")
    @ApiOperation(value="Create a new user.")
    @ApiImplicitParam(name="user", value="A JSON object representing the new user, with a unique username and a valid password.", dataType="String", paramType="body")
    private boolean createUser(Request request, Response response) {
        try {
            Json user = Json.read((String)request.body());
            if (this.users.userExists(user.at("user-name").asString())) {
                return false;
            }
            this.users.addUser(user);
            return true;
        }
        catch (Exception e) {
            this.LOG.error("Error during creating new user", (Throwable)e);
            throw GraknServerException.serverException((int)500, (Exception)e);
        }
    }

    @GET
    @Path(value="/one/:user-name")
    @ApiOperation(value="Delete a user.")
    @ApiImplicitParam(name="user-name", value="Username of user.", required=true, dataType="string", paramType="path")
    private boolean removeUser(Request request, Response response) {
        return this.users.removeUser(request.params("user-name"));
    }

    @PUT
    @Path(value="/one")
    @ApiOperation(value="Update an existing user.")
    @ApiImplicitParam(name="user", value="A JSON object representing the user.", dataType="String", paramType="body")
    private boolean updateUser(Request request, Response response) {
        Json user = Json.read((String)request.body());
        return this.users.userExists(user.at("user-name").asString()) && this.users.updateUser(user);
    }
}

