/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller.api;

import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.engine.controller.util.Requests;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import java.util.Optional;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Service;

public class AttributeController {
    private final EngineGraknTxFactory factory;
    private static final Logger LOG = LoggerFactory.getLogger(AttributeController.class);

    public AttributeController(EngineGraknTxFactory factory, Service spark) {
        this.factory = factory;
        spark.post("/api/attributeType/:attributeTypeLabel", this::postAttribute);
    }

    private Json postAttribute(Request request, Response response) {
        LOG.debug("postAttribute - request received.");
        String attributeTypeLabel = Requests.mandatoryPathParameter(request, ":attributeTypeLabel");
        Json requestBody = Json.read((String)Requests.mandatoryBody(request));
        String attributeValue = Requests.extractJsonField(requestBody, "value").asString();
        String keyspace = Requests.mandatoryQueryParameter(request, "keyspace");
        LOG.debug("postAttribute - attempting to find attributeType " + attributeTypeLabel + " in keyspace " + keyspace);
        try (GraknTx tx = this.factory.tx(Keyspace.of((String)keyspace), GraknTxType.WRITE);){
            Optional<AttributeType> attributeTypeOptional = Optional.ofNullable(tx.getAttributeType(attributeTypeLabel));
            if (attributeTypeOptional.isPresent()) {
                LOG.debug("postAttribute - attributeType " + attributeTypeLabel + " found.");
                AttributeType attributeType = attributeTypeOptional.get();
                Attribute attribute = attributeType.putAttribute((Object)attributeValue);
                tx.commit();
                String jsonConceptId = attribute.getId().getValue();
                Object jsonAttributeValue = attribute.getValue();
                LOG.debug("postAttribute - attribute " + jsonConceptId + " of attributeType " + attributeTypeLabel + " added. request processed");
                response.status(200);
                Json json = this.attributeJson(jsonConceptId, jsonAttributeValue);
                return json;
            }
            LOG.debug("postAttribute - attributeType " + attributeTypeLabel + " NOT found.");
            response.status(400);
            Json json = Json.nil();
            return json;
        }
    }

    private Json attributeJson(String conceptId, Object value) {
        return Json.object((Object[])new Object[]{"attribute", Json.object((Object[])new Object[]{"conceptId", conceptId, "value", value})});
    }
}

