/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller.api;

import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.EntityType;
import ai.grakn.engine.controller.util.Requests;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import java.util.Optional;
import java.util.function.BiConsumer;
import mjson.Json;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Service;

public class EntityTypeController {
    private final EngineGraknTxFactory factory;
    private static final Logger LOG = LoggerFactory.getLogger(EntityTypeController.class);

    public EntityTypeController(EngineGraknTxFactory factory, Service spark) {
        this.factory = factory;
        spark.get("/api/entityType/:entityTypeLabel", this::getEntityType);
        spark.post("/api/entityType", this::postEntityType);
        spark.delete("/api/entityType/:entityTypeLabel", this::deleteEntityType);
        spark.put("/api/entityType/:entityTypeLabel/attributeType/:attributeTypeLabel", this::assignAttributeTypeToEntityType);
        spark.delete("/api/entityType/:entityTypeLabel/attributeType/:attributeTypeLabel", this::deleteAttributeTypeToEntityTypeAssignment);
    }

    private Json getEntityType(Request request, Response response) {
        LOG.debug("getEntityType - request received.");
        String entityTypeLabel = Requests.mandatoryPathParameter(request, ":entityTypeLabel");
        String keyspace = Requests.mandatoryQueryParameter(request, "keyspace");
        LOG.debug("getEntityType - attempting to find entityType " + entityTypeLabel + " in keyspace " + keyspace);
        try (GraknTx tx = this.factory.tx(Keyspace.of((String)keyspace), GraknTxType.READ);){
            Optional<EntityType> entityType = Optional.ofNullable(tx.getEntityType(entityTypeLabel));
            if (entityType.isPresent()) {
                String jsonConceptId = entityType.get().getId().getValue();
                String jsonEntityTypeLabel = entityType.get().getLabel().getValue();
                response.status(200);
                Json responseBody = this.entityTypeJson(jsonConceptId, jsonEntityTypeLabel);
                LOG.debug("getEntityType - entityType found - " + jsonConceptId + ", " + jsonEntityTypeLabel + ". request processed.");
                Json json = responseBody;
                return json;
            }
            response.status(400);
            LOG.debug("getEntityType - entityType NOT found. request processed.");
            Json json = Json.nil();
            return json;
        }
    }

    private Json postEntityType(Request request, Response response) {
        LOG.debug("postEntityType - request received");
        Json requestBody = Json.read((String)Requests.mandatoryBody(request));
        String entityTypeLabel = Requests.extractJsonField(requestBody, "entityType", "label").asString();
        String keyspace = Requests.mandatoryQueryParameter(request, "keyspace");
        LOG.debug("postEntityType - attempting to add entityType " + entityTypeLabel + " in keyspace " + keyspace);
        try (GraknTx tx = this.factory.tx(Keyspace.of((String)keyspace), GraknTxType.WRITE);){
            EntityType entityType = tx.putEntityType(entityTypeLabel);
            tx.commit();
            response.status(200);
            String jsonConceptId = entityType.getId().getValue();
            String jsonEntityTypeLabel = entityType.getLabel().getValue();
            Json responseBody = this.entityTypeJson(jsonConceptId, jsonEntityTypeLabel);
            LOG.debug("postEntityType - entityType added - " + jsonConceptId + ", " + jsonEntityTypeLabel + ". request processed.");
            Json json = responseBody;
            return json;
        }
    }

    public Json deleteEntityType(Request request, Response response) {
        LOG.debug("deleteEntityType - request received.");
        String entityTypeLabel = Requests.mandatoryPathParameter(request, ":entityTypeLabel");
        String keyspace = Requests.mandatoryQueryParameter(request, "keyspace");
        LOG.debug("deleteEntityType - attempting to find entityType " + entityTypeLabel + " in keyspace " + keyspace);
        try (GraknTx tx = this.factory.tx(Keyspace.of((String)keyspace), GraknTxType.READ);){
            Optional<EntityType> entityTypeOptional = Optional.ofNullable(tx.getEntityType(entityTypeLabel));
            if (entityTypeOptional.isPresent()) {
                EntityType entityType = entityTypeOptional.get();
                entityType.delete();
                response.status(200);
                Json responseBody = Json.object();
                LOG.debug("deleteEntityType - entityType " + entityTypeLabel + " deleted.");
                Json json = responseBody;
                return json;
            }
            response.status(400);
            LOG.debug("deleteEntityType - entityType " + entityTypeLabel + " NOT found. request processed.");
            Json json = Json.nil();
            return json;
        }
    }

    private Json assignAttributeTypeToEntityType(Request request, Response response) {
        LOG.debug("assignAttributeTypeToEntityType - request received.");
        String entityTypeLabel = Requests.mandatoryPathParameter(request, ":entityTypeLabel");
        String attributeTypeLabel = Requests.mandatoryPathParameter(request, ":attributeTypeLabel");
        String keyspace = Requests.mandatoryQueryParameter(request, "keyspace");
        LOG.debug("assignAttributeTypeToEntityType - attempting to assign attributeType " + attributeTypeLabel + " to entityType " + entityTypeLabel + ", in keyspace " + keyspace);
        BiConsumer<EntityType, AttributeType> whenFound = (entity, attribute) -> {
            entity.attribute(attribute);
            LOG.debug("assignAttributeTypeToEntityType - attributeType " + attributeTypeLabel + " assigned to entityType " + entityTypeLabel + ". request processed.");
        };
        BiConsumer<Optional<EntityType>, Optional<AttributeType>> whenNotFound = (entityTypeOptional, attributeTypeOptional) -> {
            String entityInfo = entityTypeOptional.map(e -> e.toString()).orElse("<empty>");
            String attributeInfo = attributeTypeOptional.map(e -> e.toString()).orElse("<empty>");
            LOG.debug("assignAttributeTypeToEntityType - either entityType '" + entityInfo + "' or attributeType '" + attributeInfo + "' not found. request processed.");
        };
        Pair<Integer, Json> assignAttribute = this.withEntityAndAttribute(keyspace, entityTypeLabel, attributeTypeLabel, whenFound, whenNotFound);
        response.status(((Integer)assignAttribute.getLeft()).intValue());
        return (Json)assignAttribute.getRight();
    }

    private Json deleteAttributeTypeToEntityTypeAssignment(Request request, Response response) {
        LOG.debug("deleteAttributeTypeToEntityTypeAssignment - request received.");
        String entityTypeLabel = Requests.mandatoryPathParameter(request, ":entityTypeLabel");
        String attributeTypeLabel = Requests.mandatoryPathParameter(request, ":attributeTypeLabel");
        String keyspace = Requests.mandatoryQueryParameter(request, "keyspace");
        LOG.debug("deleteAttributeTypeToEntityTypeAssignment - attempting to assign attributeType " + attributeTypeLabel + " to entityType " + entityTypeLabel + ", in keyspace " + keyspace);
        BiConsumer<EntityType, AttributeType> whenFound = (entity, attribute) -> {
            entity.deleteAttribute(attribute);
            LOG.debug("deleteAttributeTypeToEntityTypeAssignment - attributeType " + attributeTypeLabel + " assigned to entityType " + entityTypeLabel + ". request processed.");
        };
        BiConsumer<Optional<EntityType>, Optional<AttributeType>> whenNotFound = (entityTypeOptional, attributeTypeOptional) -> {
            String entityInfo = entityTypeOptional.map(e -> e.toString()).orElse("<empty>");
            String attributeInfo = attributeTypeOptional.map(e -> e.toString()).orElse("<empty>");
            LOG.debug("deleteAttributeTypeToEntityTypeAssignment - either entityType '" + entityInfo + "' or attributeType '" + attributeInfo + "' not found. request processed.");
        };
        Pair<Integer, Json> deleteAttributeAssignment = this.withEntityAndAttribute(keyspace, entityTypeLabel, attributeTypeLabel, whenFound, whenNotFound);
        response.status(((Integer)deleteAttributeAssignment.getLeft()).intValue());
        return (Json)deleteAttributeAssignment.getRight();
    }

    private Json entityTypeJson(String conceptId, String label) {
        return Json.object((Object[])new Object[]{"entityType", Json.object((Object[])new Object[]{"conceptId", conceptId, "label", label})});
    }

    private Pair<Integer, Json> withEntityAndAttribute(String keyspace, String entityTypeLabel, String attributeTypeLabel, BiConsumer<EntityType, AttributeType> whenFound, BiConsumer<Optional<EntityType>, Optional<AttributeType>> whenNotFound) {
        try (GraknTx tx = this.factory.tx(Keyspace.of((String)keyspace), GraknTxType.WRITE);){
            Optional<EntityType> entityTypeOptional = Optional.ofNullable(tx.getEntityType(entityTypeLabel));
            Optional<AttributeType> attributeTypeOptional = Optional.ofNullable(tx.getAttributeType(attributeTypeLabel));
            if (entityTypeOptional.isPresent() && attributeTypeOptional.isPresent()) {
                EntityType entityType = entityTypeOptional.get();
                AttributeType attributeType = attributeTypeOptional.get();
                whenFound.accept(entityType, attributeType);
                tx.commit();
                Pair pair = Pair.of((Object)200, (Object)Json.object());
                return pair;
            }
            whenNotFound.accept(entityTypeOptional, attributeTypeOptional);
            Pair pair = Pair.of((Object)400, (Object)Json.nil());
            return pair;
        }
    }
}

