/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller.api;

import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Entity;
import ai.grakn.concept.Relationship;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.engine.controller.util.Requests;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import java.util.Optional;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Service;

public class RelationshipController {
    private final EngineGraknTxFactory factory;
    private static final Logger LOG = LoggerFactory.getLogger(RelationshipController.class);

    public RelationshipController(EngineGraknTxFactory factory, Service spark) {
        this.factory = factory;
        spark.post("/api/relationshipType/:relationshipTypeLabel", this::postRelationship);
        spark.put("/api/relationship/:relationshipConceptId/entity/:entityConceptId/role/:roleLabel", this::assignEntityAndRoleToRelationship);
    }

    private Json postRelationship(Request request, Response response) {
        LOG.debug("postRelationship - request received.");
        String relationshipTypeLabel = Requests.mandatoryPathParameter(request, ":relationshipTypeLabel");
        String keyspace = Requests.mandatoryQueryParameter(request, "keyspace");
        LOG.debug("postRelationship - attempting to find entityType " + relationshipTypeLabel + " in keyspace " + keyspace);
        try (GraknTx tx = this.factory.tx(Keyspace.of((String)keyspace), GraknTxType.WRITE);){
            Optional<RelationshipType> relationshipTypeOptional = Optional.ofNullable(tx.getRelationshipType(relationshipTypeLabel));
            if (relationshipTypeOptional.isPresent()) {
                LOG.debug("postRelationship - relationshipType " + relationshipTypeLabel + " found.");
                RelationshipType relationshipType = relationshipTypeOptional.get();
                Relationship relationship = relationshipType.addRelationship();
                String jsonConceptId = relationship.getId().getValue();
                LOG.debug("postRelationship - relationship " + jsonConceptId + " of relationshipType " + relationshipTypeLabel + " added. request processed");
                response.status(200);
                Json json = this.relationshipJson(jsonConceptId);
                return json;
            }
            LOG.debug("postRelationship - relationshipType " + relationshipTypeLabel + " NOT found.");
            response.status(400);
            Json json = Json.nil();
            return json;
        }
    }

    private Json assignEntityAndRoleToRelationship(Request request, Response response) {
        LOG.debug("assignEntityAndRoleToRelationship - request received.");
        String relationshipConceptId = Requests.mandatoryPathParameter(request, ":relationshipConceptId");
        String roleLabel = Requests.mandatoryPathParameter(request, ":roleLabel");
        String entityConceptId = Requests.mandatoryPathParameter(request, ":entityConceptId");
        String keyspace = Requests.mandatoryQueryParameter(request, "keyspace");
        try (GraknTx tx = this.factory.tx(Keyspace.of((String)keyspace), GraknTxType.WRITE);){
            LOG.debug("assignEntityAndRoleToRelationship - attempting to find roleLabel " + roleLabel + " and relationshipConceptId " + relationshipConceptId + ", in keyspace " + keyspace);
            Optional<Concept> relationshipOptional = Optional.ofNullable(tx.getConcept(ConceptId.of((String)relationshipConceptId)));
            Optional<Role> roleOptional = Optional.ofNullable(tx.getRole(roleLabel));
            Optional<Concept> entityOptional = Optional.ofNullable(tx.getConcept(ConceptId.of((String)entityConceptId)));
            if (relationshipOptional.isPresent() && roleOptional.isPresent() && entityOptional.isPresent()) {
                LOG.debug("assignEntityAndRoleToRelationship - relationship, role and entity found. attempting to assign entity " + entityConceptId + " and role  " + roleLabel + " to relationship " + relationshipConceptId);
                Relationship relationship = (Relationship)relationshipOptional.get();
                Role role = roleOptional.get();
                Entity entity = (Entity)entityOptional.get();
                relationship.addRolePlayer(role, (Thing)entity);
                tx.commit();
                LOG.debug("assignEntityAndRoleToRelationship - assignment succeeded. request processed.");
                Json responseBody = Json.object();
                response.status(200);
                Json json = responseBody;
                return json;
            }
            LOG.debug("assignEntityAndRoleToRelationship - either entity, role or relationship not found. request processed.");
            response.status(400);
            Json json = Json.nil();
            return json;
        }
    }

    private Json relationshipJson(String conceptId) {
        return Json.object((Object[])new Object[]{"relationship", Json.object((Object[])new Object[]{"conceptId", conceptId})});
    }
}

