/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.data;

import ai.grakn.engine.util.SimpleURI;
import ai.grakn.exception.GraknBackendException;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.util.Pool;

public class RedisWrapper {
    private Pool<Jedis> jedisPool;
    private Set<String> uriSet;

    private RedisWrapper(Pool<Jedis> jedisPool, Set<String> uriSet) {
        this.jedisPool = jedisPool;
        this.uriSet = uriSet;
    }

    public Pool<Jedis> getJedisPool() {
        return this.jedisPool;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void close() {
        this.jedisPool.close();
    }

    public void testConnection() {
        try {
            this.getJedisPool().getResource();
        }
        catch (JedisConnectionException e) {
            throw GraknBackendException.serverStartupException((String)("Redis is not available. Make sure it's running on " + String.join((CharSequence)", ", this.uriSet)), (Exception)((Object)e));
        }
    }

    public static class Builder {
        static final int DEFAULT_PORT = 6379;
        static final int TIMEOUT = 5000;
        private boolean useSentinel = false;
        private Set<String> uriSet = new HashSet<String>();
        private String masterName = null;
        private int poolSize = 32;

        public Builder setUseSentinel(boolean useSentinel) {
            this.useSentinel = useSentinel;
            return this;
        }

        public Builder addURI(String uri) {
            this.uriSet.add(uri);
            return this;
        }

        public Builder setURI(Collection<String> uri) {
            this.uriSet = new HashSet<String>(uri);
            return this;
        }

        public Builder setMasterName(String masterName) {
            this.masterName = masterName;
            return this;
        }

        public Builder setPoolSize(int poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        public RedisWrapper build() {
            JedisSentinelPool jedisPool;
            Preconditions.checkState((!this.uriSet.isEmpty() ? 1 : 0) != 0, (Object)"Trying to build RedisWrapper without uriSet");
            Preconditions.checkState((this.useSentinel || this.uriSet.size() <= 1 ? 1 : 0) != 0, (Object)"More than one URL provided but Sentinel not used");
            Preconditions.checkState((!this.useSentinel || this.masterName != null ? 1 : 0) != 0, (Object)"Using Sentinel but master name not provided");
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setTestOnBorrow(true);
            poolConfig.setTestOnReturn(true);
            poolConfig.setMaxTotal(this.poolSize);
            if (this.useSentinel) {
                jedisPool = new JedisSentinelPool(this.masterName, this.uriSet, (GenericObjectPoolConfig)poolConfig, 5000);
            } else {
                String uri = (String)this.uriSet.stream().findFirst().get();
                SimpleURI simpleURI = SimpleURI.withDefaultPort(uri, 6379);
                jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, simpleURI.getHost(), simpleURI.getPort(), 5000);
            }
            return new RedisWrapper((Pool)jedisPool, this.uriSet);
        }
    }
}

