/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.postprocessing;

import ai.grakn.GraknTx;
import ai.grakn.Keyspace;
import ai.grakn.concept.ConceptId;
import ai.grakn.engine.postprocessing.GraknTxMutators;
import ai.grakn.engine.tasks.BackgroundTask;
import ai.grakn.engine.tasks.manager.TaskConfiguration;
import ai.grakn.engine.tasks.manager.TaskSchedule;
import ai.grakn.engine.tasks.manager.TaskState;
import ai.grakn.util.Schema;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostProcessingTask
extends BackgroundTask {
    private static final Logger LOG = LoggerFactory.getLogger(PostProcessingTask.class);
    private static final String JOB_FINISHED = "Post processing Job [{}] completed for indeces and ids: [{}]";
    private static final String LOCK_KEY = "/post-processing-lock";

    @Override
    public boolean start() {
        try (Timer.Context context = this.metricRegistry().timer(MetricRegistry.name(PostProcessingTask.class, (String[])new String[]{"execution"})).time();){
            Map<String, Set<ConceptId>> allToPostProcess = PostProcessingTask.getPostProcessingJobs(Schema.BaseType.ATTRIBUTE, this.configuration());
            allToPostProcess.forEach((conceptIndex, conceptIds) -> {
                Timer.Context contextSingle = this.metricRegistry().timer(MetricRegistry.name(PostProcessingTask.class, (String[])new String[]{"execution-single"})).time();
                try {
                    Keyspace keyspace = Keyspace.of((String)this.configuration().json().at("keyspace").asString());
                    int maxRetry = this.engineConfiguration().getPropertyAsInt("loader.repeat-commits");
                    GraknTxMutators.runMutationWithRetry(this.factory(), keyspace, maxRetry, graph -> this.runPostProcessingMethod((GraknTx)graph, (String)conceptIndex, (Set<ConceptId>)conceptIds));
                }
                finally {
                    contextSingle.stop();
                }
            });
            LOG.debug(JOB_FINISHED, (Object)Schema.BaseType.ATTRIBUTE.name(), allToPostProcess);
            boolean bl = true;
            return bl;
        }
    }

    private static Map<String, Set<ConceptId>> getPostProcessingJobs(Schema.BaseType type, TaskConfiguration configuration) {
        return configuration.json().at("concepts-to-fix").at(type.name()).asJsonMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Json)e.getValue()).asList().stream().map(o -> ConceptId.of((String)o.toString())).collect(Collectors.toSet())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPostProcessingMethod(GraknTx graph, String conceptIndex, Set<ConceptId> conceptIds) {
        Preconditions.checkNotNull((Object)this.getLockProvider(), (Object)"Lock provider was null, possible race condition in initialisation");
        if (graph.admin().duplicateResourcesExist(conceptIndex, conceptIds)) {
            Lock indexLock = this.getLockProvider().getLock("/post-processing-lock/" + conceptIndex);
            indexLock.lock();
            try {
                graph.admin().fixDuplicateResources(conceptIndex, conceptIds);
                this.validateMerged(graph, conceptIndex, conceptIds).ifPresent(message -> {
                    throw new RuntimeException((String)message);
                });
                graph.admin().commitNoLogs();
            }
            finally {
                indexLock.unlock();
            }
        }
    }

    private Optional<String> validateMerged(GraknTx graph, String conceptIndex, Set<ConceptId> conceptIds) {
        int numConceptFound = 0;
        for (ConceptId conceptId : conceptIds) {
            if (graph.getConcept(conceptId) == null || ++numConceptFound <= 1) continue;
            StringBuilder conceptIdValues = new StringBuilder();
            for (ConceptId id : conceptIds) {
                conceptIdValues.append(id.getValue()).append(",");
            }
            return Optional.of("Not all concept were merged. The set of concepts [" + conceptIds.size() + "] with IDs [" + conceptIdValues.toString() + "] matched more than one concept");
        }
        if (graph.admin().getConcept(Schema.VertexProperty.INDEX, (Object)conceptIndex) == null) {
            return Optional.of("The concept index [" + conceptIndex + "] did not return any concept");
        }
        return Optional.empty();
    }

    public static TaskState createTask(Class creator, int delay) {
        return TaskState.of(PostProcessingTask.class, creator.getName(), TaskSchedule.at(Instant.now().plusMillis(delay)), TaskState.Priority.LOW);
    }

    public static TaskConfiguration createConfig(Keyspace keyspace, String config) {
        Json postProcessingConfiguration = Json.object();
        postProcessingConfiguration.set("keyspace", (Object)keyspace.getValue());
        postProcessingConfiguration.set("concepts-to-fix", Json.read((String)config).at("concepts-to-fix"));
        return TaskConfiguration.of(postProcessingConfiguration);
    }
}

