/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.tasks;

import ai.grakn.engine.GraknEngineConfig;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import ai.grakn.engine.lock.LockProvider;
import ai.grakn.engine.tasks.connection.RedisCountStorage;
import ai.grakn.engine.tasks.manager.TaskCheckpoint;
import ai.grakn.engine.tasks.manager.TaskConfiguration;
import ai.grakn.engine.tasks.manager.TaskState;
import ai.grakn.engine.tasks.manager.TaskSubmitter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public abstract class BackgroundTask {
    @Nullable
    private TaskSubmitter taskSubmitter = null;
    @Nullable
    private TaskConfiguration configuration = null;
    @Nullable
    private Consumer<TaskCheckpoint> saveCheckpoint = null;
    @Nullable
    private GraknEngineConfig engineConfig = null;
    @Nullable
    private EngineGraknTxFactory factory = null;
    @Nullable
    private RedisCountStorage redis = null;
    @Nullable
    private MetricRegistry metricRegistry = null;
    @Nullable
    private LockProvider lockProvider = null;

    public final void initialize(Consumer<TaskCheckpoint> saveCheckpoint, TaskConfiguration configuration, TaskSubmitter taskSubmitter, GraknEngineConfig engineConfig, RedisCountStorage redis, EngineGraknTxFactory factory, LockProvider lockProvider, MetricRegistry metricRegistry) {
        this.configuration = configuration;
        this.taskSubmitter = taskSubmitter;
        this.saveCheckpoint = saveCheckpoint;
        this.engineConfig = engineConfig;
        this.redis = redis;
        this.lockProvider = lockProvider;
        this.metricRegistry = metricRegistry;
        this.factory = factory;
    }

    public abstract boolean start();

    public boolean stop() {
        throw new UnsupportedOperationException(this.getClass().getName() + " task cannot be stopped while in progress");
    }

    public void pause() {
        throw new UnsupportedOperationException(this.getClass().getName() + " task cannot be paused");
    }

    public boolean resume(TaskCheckpoint lastCheckpoint) {
        throw new UnsupportedOperationException(this.getClass().getName() + " task cannot be resumed");
    }

    public final void saveCheckpoint(TaskCheckpoint checkpoint) {
        Preconditions.checkNotNull(this.saveCheckpoint, (Object)"BackgroundTask#initialise must be called before saving checkpoints");
        this.saveCheckpoint.accept(checkpoint);
    }

    public final void addTask(TaskState taskState, TaskConfiguration configuration) {
        Preconditions.checkNotNull((Object)this.taskSubmitter, (Object)"BackgroundTask#initialise must be called before adding tasks");
        this.taskSubmitter.addTask(taskState, configuration);
    }

    public final TaskConfiguration configuration() {
        Preconditions.checkNotNull((Object)this.configuration, (Object)"BackgroundTask#initialise must be called before retrieving configuration");
        return this.configuration;
    }

    public final GraknEngineConfig engineConfiguration() {
        Preconditions.checkNotNull((Object)this.engineConfig, (Object)"BackgroundTask#initialise must be called before retrieving engine configuration");
        return this.engineConfig;
    }

    public final RedisCountStorage redis() {
        Preconditions.checkNotNull((Object)this.redis, (Object)"BackgroundTask#initialise must be called before retrieving redis connection");
        return this.redis;
    }

    public final EngineGraknTxFactory factory() {
        Preconditions.checkNotNull((Object)this.factory, (Object)"BackgroundTask#initialise must be called before retrieving the engine factory");
        return this.factory;
    }

    public final MetricRegistry metricRegistry() {
        Preconditions.checkNotNull((Object)this.metricRegistry, (Object)"BackgroundTask#initialise must be called before retrieving metrics registry");
        return this.metricRegistry;
    }

    public LockProvider getLockProvider() {
        Preconditions.checkNotNull((Object)this.lockProvider, (Object)"Lock provider was null, possible race condition in initialisation");
        return this.lockProvider;
    }
}

