/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.tasks.manager;

import java.io.Serializable;
import java.time.Instant;
import mjson.Json;

public class TaskCheckpoint
implements Serializable {
    private static final long serialVersionUID = -7301340972479426643L;
    private final Json checkpoint;
    private final Instant createdAt;

    public static TaskCheckpoint of(Json checkpoint) {
        return new TaskCheckpoint(checkpoint);
    }

    private TaskCheckpoint(Json checkpoint) {
        this.checkpoint = checkpoint;
        this.createdAt = Instant.now();
    }

    public Json checkpoint() {
        return this.checkpoint;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskCheckpoint that = (TaskCheckpoint)o;
        return this.checkpoint.toString().equals(that.checkpoint.toString()) && this.createdAt.equals(that.createdAt);
    }

    public int hashCode() {
        int result = this.checkpoint != null ? this.checkpoint.hashCode() : 0;
        result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TaskCheckpoint.of(" + this.checkpoint + ")";
    }
}

