/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.tasks.manager;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class TaskSchedule
implements Serializable {
    private static final long serialVersionUID = 8220146809708041152L;
    private final Instant runAt;
    @Nullable
    private final Duration interval;

    public static TaskSchedule now() {
        return TaskSchedule.at(Instant.now());
    }

    public static TaskSchedule at(Instant instant) {
        return new TaskSchedule(instant, null);
    }

    public static TaskSchedule recurring(Duration interval) {
        return TaskSchedule.recurring(Instant.now(), interval);
    }

    public static TaskSchedule recurring(Instant instant, Duration interval) {
        return new TaskSchedule(instant, Objects.requireNonNull(interval));
    }

    public TaskSchedule(Instant runAt, @Nullable Duration interval) {
        this.runAt = Objects.requireNonNull(runAt);
        this.interval = interval;
    }

    @JsonCreator
    public TaskSchedule(@JsonProperty(value="runAt") long runAt, @JsonProperty(value="interval") @Nullable Long interval) {
        this(Instant.ofEpochMilli(runAt), interval != null ? Duration.ofMillis(interval) : null);
    }

    public Instant runAt() {
        return this.runAt;
    }

    @JsonProperty(value="runAt")
    public long getRunAt() {
        return this.runAt.toEpochMilli();
    }

    public Optional<Duration> interval() {
        return Optional.ofNullable(this.interval);
    }

    @JsonProperty(value="interval")
    public Long getInterval() {
        return this.interval != null ? Long.valueOf(this.interval.toMillis()) : null;
    }

    @JsonIgnore
    public boolean isRecurring() {
        return this.interval != null;
    }

    public TaskSchedule incrementByInterval() {
        return new TaskSchedule(this.runAt.plus(this.interval), this.interval);
    }
}

