/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.tasks.manager;

import ai.grakn.engine.TaskId;
import ai.grakn.engine.TaskStatus;
import ai.grakn.engine.tasks.manager.TaskState;
import ai.grakn.engine.tasks.manager.TaskStateStorage;
import ai.grakn.engine.util.EngineID;
import ai.grakn.exception.GraknBackendException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class TaskStateInMemoryStore
implements TaskStateStorage {
    private final Map<TaskId, TaskState> storage = new ConcurrentHashMap<TaskId, TaskState>();
    private final Queue<TaskId> finishedTasks = new ArrayBlockingQueue<TaskId>(10000);
    private static final int MAX_FINISHED_TASKS = 10000;

    @Override
    public TaskId newState(TaskState state) {
        this.updateState(state);
        return state.getId();
    }

    @Override
    public Boolean updateState(TaskState state) {
        boolean taskFinished;
        TaskId taskId = state.getId();
        boolean bl = taskFinished = state.getStatus() == TaskStatus.COMPLETED || state.getStatus() == TaskStatus.FAILED;
        if (taskFinished) {
            while (!this.finishedTasks.offer(taskId)) {
                TaskId oldestFinishedTask = this.finishedTasks.poll();
                this.storage.remove(oldestFinishedTask);
            }
        }
        this.storage.put(taskId, state.copy());
        return true;
    }

    @Override
    public TaskState getState(TaskId id) {
        Optional<TaskState> taskState = Optional.ofNullable(this.storage.get(id));
        if (!taskState.isPresent()) {
            throw GraknBackendException.stateStorageMissingId((TaskId)id);
        }
        return taskState.get().copy();
    }

    @Override
    public boolean containsTask(TaskId id) {
        return this.storage.containsKey(id);
    }

    @Override
    public Set<TaskState> getTasks(@Nullable TaskStatus taskStatus, @Nullable String taskClassName, @Nullable String createdBy, @Nullable EngineID engineRunningOn, int limit, int offset) {
        HashSet<TaskState> res = new HashSet<TaskState>();
        int count = 0;
        for (Map.Entry<TaskId, TaskState> x : this.storage.entrySet()) {
            TaskState state = x.getValue();
            if (state == null || taskStatus != null && state.status() != taskStatus || taskClassName != null && !Objects.equals(state.taskClass().getName(), taskClassName) || createdBy != null && !Objects.equals(state.creator(), createdBy) || engineRunningOn != null && !Objects.equals(state.engineID(), engineRunningOn)) continue;
            if (count < offset) {
                ++count;
                continue;
            }
            if (limit > 0 && count >= limit + offset) break;
            ++count;
            res.add(state.copy());
        }
        return res;
    }

    @Override
    public void clear() {
        this.storage.clear();
        this.finishedTasks.clear();
    }
}

