/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.user;

import ai.grakn.engine.factory.EngineGraknTxFactory;
import ai.grakn.engine.user.SystemKeyspaceUsers;
import java.util.HashMap;
import java.util.Map;
import mjson.Json;

public class UsersHandler {
    public static final String SUPERUSER = "admin";
    public static final String USER_ENTITY = "user";
    public static final String USER_NAME = "user-name";
    public static final String USER_PASSWORD = "user-password";
    public static final String USER_SALT = "user-password-salt";
    public static final String USER_FIRST_NAME = "user-first-name";
    public static final String USER_LAST_NAME = "user-last-name";
    public static final String USER_EMAIL = "user-email";
    public static final String USER_IS_ADMIN = "user-is-admin";
    private final Map<String, Json> usersMap = new HashMap<String, Json>();
    final String adminPassword;

    public static UsersHandler create(String adminPassword, EngineGraknTxFactory factory) {
        return new SystemKeyspaceUsers(adminPassword, factory);
    }

    protected UsersHandler(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String superUsername() {
        return SUPERUSER;
    }

    public boolean addUser(Json user) {
        String username = user.at(USER_NAME).asString();
        if (this.superUsername().equals(username) || this.usersMap.containsKey(username)) {
            return false;
        }
        this.usersMap.put(username, user);
        return true;
    }

    public boolean updateUser(Json user) {
        String username = user.at(USER_NAME).asString();
        if (this.superUsername().equals(username) || !this.usersMap.containsKey(username)) {
            return false;
        }
        this.usersMap.put(user.at(USER_NAME).asString(), user);
        return true;
    }

    public boolean userExists(String username) {
        return this.superUsername().equals(username) || this.usersMap.containsKey(username);
    }

    public boolean validateUser(String username, String hashedPassword) {
        if (this.superUsername().equals(username)) {
            return hashedPassword.equals(this.adminPassword);
        }
        if (this.userExists(username)) {
            return this.getUser(username).is(USER_PASSWORD, (Object)hashedPassword);
        }
        return false;
    }

    public Json getUser(String username) {
        return this.superUsername().equals(username) ? Json.object((Object[])new Object[]{USER_NAME, this.superUsername()}) : this.usersMap.get(username);
    }

    public boolean removeUser(String username) {
        if (this.superUsername().equals(username)) {
            return false;
        }
        return this.usersMap.remove(username) != null;
    }

    public Json allUsers(int offset, int limit) {
        return Json.make(this.usersMap.values());
    }
}

