/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.util;

import com.google.common.base.Preconditions;

public class SimpleURI {
    private final int port;
    private final String host;

    public SimpleURI(String uri) {
        String[] uriSplit = uri.split(":");
        Preconditions.checkArgument((uriSplit.length == 2 ? 1 : 0) != 0, (Object)("Malformed URI " + uri));
        this.host = uriSplit[0].trim();
        this.port = Integer.parseInt(uriSplit[1].trim());
    }

    public SimpleURI(String host, int port) {
        this.port = port;
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String toString() {
        return String.format("%s:%d", this.host, this.port);
    }

    public static SimpleURI withDefaultPort(String uri, int defaultPort) {
        if (uri.contains(":")) {
            return new SimpleURI(uri);
        }
        return new SimpleURI(uri, defaultPort);
    }
}

