/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine;

import ai.grakn.GraknSystemProperty;
import ai.grakn.util.ErrorMessage;
import com.google.common.base.StandardSystemProperty;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraknEngineConfig {
    public static final String GRAKN_VERSION_KEY = "grakn.version";
    public static final String DEFAULT_CONFIG_FILE = "../conf/main/grakn.properties";
    public static final String DEFAULT_KEYSPACE_PROPERTY = "knowledge-base.default-keyspace";
    public static final String NUM_THREADS_PROPERTY = "loader.threads";
    public static final String JWT_SECRET_PROPERTY = "JWT.secret";
    public static final String PASSWORD_PROTECTED_PROPERTY = "password.protected";
    public static final String WEBSERVER_THREADS = "webserver.threads";
    public static final String ADMIN_PASSWORD_PROPERTY = "admin.password";
    public static final String SERVER_HOST_NAME = "server.host";
    public static final String SERVER_PORT_NUMBER = "server.port";
    public static final String LOADER_REPEAT_COMMITS = "loader.repeat-commits";
    public static final String REDIS_HOST = "queue.host";
    public static final String REDIS_SENTINEL_HOST = "redis.sentinel.host";
    public static final String REDIS_SENTINEL_MASTER = "redis.sentinel.master";
    public static final String REDIS_POOL_SIZE = "redis.pool-size";
    public static final String QUEUE_CONSUMERS = "queue.consumers";
    public static final String STATIC_FILES_PATH = "server.static-file-dir";
    public static final String TASK_MANAGER_IMPLEMENTATION = "taskmanager.implementation";
    public static final String POST_PROCESSING_TASK_DELAY = "tasks.postprocessing.delay";
    public static final String TASKS_RETRY_DELAY = "tasks.retry.delay";
    public static final int WEBSOCKET_TIMEOUT = 3600000;
    private static String configFilePath = null;
    private static final Logger LOG = LoggerFactory.getLogger(GraknEngineConfig.class);
    private static final int MAX_NUMBER_OF_THREADS = 120;
    private final Properties prop = new Properties();
    private int numOfThreads = -1;
    static final String GRAKN_ASCII = "     ___  ___  ___  _  __ _  _     ___  ___     %n    / __|| _ \\/   \\| |/ /| \\| |   /   \\|_ _|    %n   | (_ ||   /| - || ' < | .` | _ | - | | |     %n    \\___||_|_\\|_|_||_|\\_\\|_|\\_|(_)|_|_||___|   %n%n Web Dashboard available at [%s]";

    public static GraknEngineConfig create() {
        GraknEngineConfig.setConfigFilePath();
        return GraknEngineConfig.read(GraknEngineConfig.getConfigFilePath());
    }

    public static GraknEngineConfig read(String path) {
        return new GraknEngineConfig(path);
    }

    private GraknEngineConfig(String path) {
        String projectPath = GraknEngineConfig.getProjectPath();
        this.setGraknVersion();
        try (FileInputStream inputStream = new FileInputStream(path);){
            this.prop.load(inputStream);
        }
        catch (IOException e) {
            LOG.error("Could not load engine properties from {}", (Object)path, (Object)e);
        }
        this.computeThreadsNumber();
        LOG.info("Project directory in use: {}", (Object)projectPath);
        LOG.info("Configuration file in use: {}", (Object)configFilePath);
        LOG.info("Number of threads set to: {}", (Object)this.numOfThreads);
    }

    private void setGraknVersion() {
        this.prop.setProperty(GRAKN_VERSION_KEY, "0.18.0");
    }

    public void setConfigProperty(String key, String value) {
        this.prop.setProperty(key, value);
    }

    private static void setConfigFilePath() {
        if (configFilePath != null && !configFilePath.isEmpty()) {
            return;
        }
        String string = configFilePath = GraknSystemProperty.CONFIGURATION_FILE.value() != null ? GraknSystemProperty.CONFIGURATION_FILE.value() : DEFAULT_CONFIG_FILE;
        if (!Paths.get(configFilePath, new String[0]).isAbsolute()) {
            configFilePath = GraknEngineConfig.getProjectPath() + configFilePath;
        }
    }

    private void computeThreadsNumber() {
        this.numOfThreads = Integer.parseInt(this.prop.getProperty(NUM_THREADS_PROPERTY));
        if (this.numOfThreads == 0) {
            int availableProcessors = Runtime.getRuntime().availableProcessors();
            LOG.warn("Number of threads set to 0 in properties. Running with {} processors instead.", (Object)availableProcessors);
            this.numOfThreads = availableProcessors;
        }
        this.numOfThreads = Math.min(120, this.numOfThreads);
    }

    public int getAvailableThreads() {
        if (this.numOfThreads == -1) {
            this.computeThreadsNumber();
        }
        return this.numOfThreads;
    }

    public String getPath(String path) {
        String propertyPath = this.prop.getProperty(path);
        if (Paths.get(propertyPath, new String[0]).isAbsolute()) {
            return propertyPath;
        }
        return GraknEngineConfig.getProjectPath() + propertyPath;
    }

    private static String getProjectPath() {
        if (GraknSystemProperty.CURRENT_DIRECTORY.value() == null) {
            GraknSystemProperty.CURRENT_DIRECTORY.set(StandardSystemProperty.USER_DIR.value());
        }
        return GraknSystemProperty.CURRENT_DIRECTORY.value() + "/";
    }

    public static String getConfigFilePath() {
        return configFilePath;
    }

    public Properties getProperties() {
        return this.prop;
    }

    public String getProperty(String property) {
        if (this.prop.containsKey(property)) {
            return this.prop.getProperty(property);
        }
        throw new RuntimeException(ErrorMessage.UNAVAILABLE_PROPERTY.getMessage(new Object[]{property, configFilePath}));
    }

    public Optional<String> tryProperty(String property) {
        return Optional.ofNullable(this.prop.getProperty(property));
    }

    public int tryIntProperty(String property, int defaultValue) {
        return Optional.ofNullable(this.prop.getProperty(property)).map(Integer::parseInt).orElse(defaultValue);
    }

    public int getPropertyAsInt(String property) {
        return Integer.parseInt(this.getProperty(property));
    }

    public long getPropertyAsLong(String property) {
        return Long.parseLong(this.getProperty(property));
    }

    public boolean getPropertyAsBool(String property, boolean defaultValue) {
        return this.prop.containsKey(property) ? Boolean.parseBoolean(this.prop.getProperty(property)) : defaultValue;
    }

    public String uri() {
        return this.getProperty(SERVER_HOST_NAME) + ":" + this.getProperty(SERVER_PORT_NUMBER);
    }

    static List<String> parseCSValue(String s) {
        return Arrays.stream(s.split(",")).map(String::trim).filter(t -> !t.isEmpty()).collect(Collectors.toList());
    }
}

