/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Role;
import ai.grakn.engine.controller.ConceptController;
import ai.grakn.engine.controller.util.Requests;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import ai.grakn.exception.GraknServerException;
import ai.grakn.graql.GetQuery;
import ai.grakn.graql.Query;
import ai.grakn.graql.internal.hal.HALBuilder;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import mjson.Json;
import spark.Request;
import spark.Response;
import spark.Service;

@Path(value="/dashboard")
public class DashboardController {
    private static final String RELATION_TYPES = "/kb/graql?query=match $a isa %s id '%s'; ($a,$b) isa %s; limit %s;&keyspace=%s&limitEmbedded=%s&infer=true&materialise=false";
    private static final String ENTITY_TYPES = "/kb/graql?query=match $a isa %s id '%s'; $b isa %s; ($a,$b); limit %s;&keyspace=%s&limitEmbedded=%s&infer=true&materialise=false";
    private static final String ROLE_TYPES = "/kb/graql?query=match $a isa %s id '%s'; ($a,%s:$b); limit %s;&keyspace=%s&limitEmbedded=%s&infer=true&materialise=false";
    private final EngineGraknTxFactory factory;

    public DashboardController(EngineGraknTxFactory factory, Service spark) {
        this.factory = factory;
        spark.get("/dashboard/types/:id", this::typesOfConcept);
        spark.get("/dashboard/explore/:id", this::exploreConcept);
        spark.get("/dashboard/explain", this::explainConcept);
    }

    @GET
    @Path(value="explore/{id}")
    @ApiOperation(value="Return the HAL Explore representation for the given concept.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="identifier", value="Identifier of the concept.", required=true, dataType="string", paramType="path"), @ApiImplicitParam(name="keyspace", value="Name of graph to use.", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="offsetEmbedded", value="Offset to begin at for embedded HAL concepts.", required=true, dataType="boolean", paramType="query"), @ApiImplicitParam(name="limitEmbedded", value="Limit on the number of embedded HAL concepts.", required=true, dataType="boolean", paramType="query")})
    private Json exploreConcept(Request request, Response response) {
        ConceptController.validateRequest(request, "application/hal+json");
        Keyspace keyspace = Keyspace.of((String)Requests.mandatoryQueryParameter(request, "keyspace"));
        ConceptId conceptId = ConceptId.of((String)ConceptController.mandatoryRequestParameter(request, ":id"));
        int offset = Requests.queryParameter(request, "offsetEmbedded").map(Integer::parseInt).orElse(0);
        int limit = Requests.queryParameter(request, "limitEmbedded").map(Integer::parseInt).orElse(-1);
        try (GraknTx graph = this.factory.tx(keyspace, GraknTxType.READ);){
            Concept concept = ConceptController.retrieveExistingConcept(graph, conceptId);
            response.type("application/hal+json");
            response.status(200);
            Json json = Json.read((String)HALBuilder.HALExploreConcept((Concept)concept, (Keyspace)keyspace, (int)offset, (int)limit));
            return json;
        }
    }

    @GET
    @Path(value="types/{id}")
    @ApiOperation(value="Return a JSON object listing: - relationTypes the current concepts plays a role in.- roleTypes played by all the other role players in all the relations the current concept takes part in- entityTypes that can play the roleTypes")
    @ApiImplicitParams(value={@ApiImplicitParam(name="identifier", value="Identifier of the concept", required=true, dataType="string", paramType="path"), @ApiImplicitParam(name="keyspace", value="Name of graph to use", required=true, dataType="string", paramType="query")})
    private Json typesOfConcept(Request request, Response response) {
        ConceptController.validateRequest(request, "application/json");
        String keyspace = Requests.mandatoryQueryParameter(request, "keyspace");
        int limit = Requests.queryParameter(request, "limitEmbedded").map(Integer::parseInt).orElse(-1);
        ConceptId conceptId = ConceptId.of((String)ConceptController.mandatoryRequestParameter(request, ":id"));
        try (GraknTx graph = this.factory.tx(keyspace, GraknTxType.READ);){
            Concept concept = ConceptController.retrieveExistingConcept(graph, conceptId);
            Json body = Json.object();
            Json responseField = Json.object();
            if (concept.isEntity()) {
                Collection rolesOfType = concept.asEntity().type().plays().collect(Collectors.toSet());
                responseField = Json.object((Object[])new Object[]{"roles", DashboardController.getRoleTypes(rolesOfType, concept, limit, keyspace), "relations", DashboardController.getRelationTypes(rolesOfType, concept, limit, keyspace), "entities", DashboardController.getEntityTypes(rolesOfType, concept, limit, keyspace)});
            }
            response.status(200);
            response.body(responseField.toString());
            Json json = body;
            return json;
        }
    }

    @GET
    @Path(value="/explain")
    @ApiOperation(value="Returns an HAL representation of the explanation tree for a given get query.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyspace", value="Name of graph to use", dataType="string", paramType="query"), @ApiImplicitParam(name="query", value="Get query to execute", required=true, dataType="string", paramType="query")})
    private Json explainConcept(Request request, Response response) {
        String keyspace = Requests.mandatoryQueryParameter(request, "keyspace");
        String queryString = Requests.mandatoryQueryParameter(request, "query");
        Json body = Json.object();
        try (GraknTx graph = this.factory.tx(keyspace, GraknTxType.READ);){
            Query query = graph.graql().infer(true).parse(queryString);
            body.set("originalQuery", (Object)query.toString());
            if (!(query instanceof GetQuery)) {
                throw GraknServerException.invalidQueryExplaination((String)query.getClass().getName());
            }
            int limitEmbedded = Requests.queryParameter(request, "limitEmbedded").map(Integer::parseInt).orElse(-1);
            response.status(200);
            Json json = HALBuilder.explanationAnswersToHAL((Stream)((GetQuery)query).stream(), (int)limitEmbedded);
            return json;
        }
    }

    private static List<Json> getRelationTypes(Collection<Role> roleTypesPlayerByConcept, Concept concept, int limit, String keyspace) {
        return roleTypesPlayerByConcept.stream().flatMap(roleType -> roleType.relationshipTypes()).map(relationType -> relationType.getLabel().getValue()).sorted().map(relationName -> Json.object((Object[])new Object[]{"value", relationName, "href", String.format(RELATION_TYPES, concept.asThing().type().getLabel().getValue(), concept.getId().getValue(), relationName, limit, keyspace, limit)})).collect(Collectors.toList());
    }

    private static List<Json> getEntityTypes(Collection<Role> roleTypesPlayerByConcept, Concept concept, int limit, String keyspace) {
        return roleTypesPlayerByConcept.stream().flatMap(roleType -> roleType.relationshipTypes()).flatMap(relationType -> relationType.relates().filter(roleType1 -> !roleTypesPlayerByConcept.contains(roleType1))).flatMap(roleType -> roleType.playedByTypes().map(entityType -> entityType.getLabel().getValue())).collect(Collectors.toSet()).stream().sorted().map(entityName -> Json.object((Object[])new Object[]{"value", entityName, "href", String.format(ENTITY_TYPES, concept.asThing().type().getLabel().getValue(), concept.getId().getValue(), entityName, limit, keyspace, limit)})).collect(Collectors.toList());
    }

    private static List<Json> getRoleTypes(Collection<Role> roleTypesPlayerByConcept, Concept concept, int limit, String keyspace) {
        return roleTypesPlayerByConcept.stream().flatMap(roleType -> roleType.relationshipTypes()).flatMap(relationType -> relationType.relates().filter(roleType1 -> !roleTypesPlayerByConcept.contains(roleType1))).map(roleType -> roleType.getLabel().getValue()).collect(Collectors.toSet()).stream().sorted().map(roleName -> Json.object((Object[])new Object[]{"value", roleName, "href", String.format(ROLE_TYPES, concept.asThing().type().getLabel().getValue(), concept.getId().getValue(), roleName, limit, keyspace, limit)})).collect(Collectors.toList());
    }
}

