/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller.api;

import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.concept.AttributeType;
import ai.grakn.engine.controller.util.Requests;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import ai.grakn.exception.GraknServerException;
import ai.grakn.graql.internal.parser.QueryParser;
import java.util.Optional;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Service;

public class AttributeTypeController {
    private final EngineGraknTxFactory factory;
    private static final Logger LOG = LoggerFactory.getLogger(AttributeTypeController.class);

    public AttributeTypeController(EngineGraknTxFactory factory, Service spark) {
        this.factory = factory;
        spark.post("/api/attributeType", this::postAttributeType);
        spark.get("/api/attributeType/:attributeTypeLabel", this::getAttributeType);
    }

    private Json postAttributeType(Request request, Response response) {
        LOG.debug("postAttributeType - request received.");
        Json requestBody = Json.read((String)Requests.mandatoryBody(request));
        String attributeTypeLabel = Requests.extractJsonField(requestBody, "attributeType", "label").asString();
        String attributeTypeDataTypeRaw = Requests.extractJsonField(requestBody, "attributeType", "type").asString();
        AttributeType.DataType<?> attributeTypeDataType = this.fromString(attributeTypeDataTypeRaw);
        String keyspace = Requests.mandatoryQueryParameter(request, "keyspace");
        LOG.debug("postAttributeType - attempting to add new attributeType " + attributeTypeLabel + " of type " + attributeTypeDataTypeRaw);
        try (GraknTx tx = this.factory.tx(Keyspace.of((String)keyspace), GraknTxType.WRITE);){
            Json responseBody;
            AttributeType attributeType = tx.putAttributeType(attributeTypeLabel, attributeTypeDataType);
            tx.commit();
            String jsonConceptId = attributeType.getId().getValue();
            String jsonAttributeTypeLabel = attributeType.getLabel().getValue();
            String jsonAttributeTypeDataType = this.toString(attributeType.getDataType());
            LOG.debug("postAttributeType - attribute type " + jsonAttributeTypeLabel + " of type " + jsonAttributeTypeDataType + " with id " + jsonConceptId + " added successfully. request processed.");
            response.status(200);
            Json json = responseBody = this.attributeTypeJson(jsonConceptId, jsonAttributeTypeLabel, jsonAttributeTypeDataType);
            return json;
        }
    }

    private Json getAttributeType(Request request, Response response) {
        LOG.debug("getAttributeType - request received.");
        String attributeTypeLabel = Requests.mandatoryPathParameter(request, ":attributeTypeLabel");
        String keyspace = Requests.mandatoryQueryParameter(request, "keyspace");
        LOG.debug("getAttributeType - attempting to find attributeType " + attributeTypeLabel + " in keyspace " + keyspace);
        try (GraknTx tx = this.factory.tx(Keyspace.of((String)keyspace), GraknTxType.READ);){
            Optional<AttributeType> attributeType = Optional.ofNullable(tx.getAttributeType(attributeTypeLabel));
            if (attributeType.isPresent()) {
                String jsonConceptId = attributeType.get().getId().getValue();
                String jsonAttributeTypeLabel = attributeType.get().getLabel().getValue();
                String jsonAttributeTypeDataType = this.toString(attributeType.get().getDataType());
                response.status(200);
                Json responseBody = this.attributeTypeJson(jsonConceptId, jsonAttributeTypeLabel, jsonAttributeTypeDataType);
                LOG.debug("getAttributeType - attributeType found - " + jsonConceptId + ", " + jsonAttributeTypeLabel + ", " + jsonAttributeTypeDataType + ". request processed.");
                Json json = responseBody;
                return json;
            }
            response.status(400);
            LOG.debug("getAttributeType - attributeType NOT found. request processed.");
            Json json = Json.nil();
            return json;
        }
    }

    private AttributeType.DataType<?> fromString(String dataType) {
        Optional<Object> fromStringOpt = Optional.ofNullable(QueryParser.DATA_TYPES.get((Object)dataType));
        return (AttributeType.DataType)fromStringOpt.orElseThrow(() -> GraknServerException.invalidQueryExplaination((String)("invalid data type supplied: '" + dataType + "'")));
    }

    private String toString(AttributeType.DataType<?> dataType) {
        Optional<Object> toStringOpt = Optional.ofNullable(QueryParser.DATA_TYPES.inverse().get(dataType));
        return (String)toStringOpt.orElseThrow(() -> GraknServerException.invalidQueryExplaination((String)("invalid data type supplied: '" + dataType + "'")));
    }

    private Json attributeTypeJson(String conceptId, String label, String dataType) {
        return Json.object((Object[])new Object[]{"attributeType", Json.object((Object[])new Object[]{"conceptId", conceptId, "label", label, "type", dataType})});
    }
}

