/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller.api;

import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.concept.Attribute;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Entity;
import ai.grakn.concept.EntityType;
import ai.grakn.engine.controller.util.Requests;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import java.util.Optional;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Service;

public class EntityController {
    private final EngineGraknTxFactory factory;
    private static final Logger LOG = LoggerFactory.getLogger(EntityController.class);

    public EntityController(EngineGraknTxFactory factory, Service spark) {
        this.factory = factory;
        spark.post("/api/entityType/:entityTypeLabel", this::postEntity);
        spark.put("/api/entity/:entityConceptId/attribute/:attributeConceptId", this::assignAttributeToEntity);
        spark.delete("/api/entity/:entityConceptId/attribute/:attributeConceptId", this::deleteAttributeToEntityAssignment);
    }

    private Json postEntity(Request request, Response response) {
        LOG.debug("postEntity - request received.");
        String entityTypeLabel = Requests.mandatoryPathParameter(request, ":entityTypeLabel");
        String keyspace = Requests.mandatoryQueryParameter(request, "keyspace");
        LOG.debug("postEntity - attempting to find entityType " + entityTypeLabel + " in keyspace " + keyspace);
        try (GraknTx tx = this.factory.tx(Keyspace.of((String)keyspace), GraknTxType.WRITE);){
            Optional<EntityType> entityTypeOptional = Optional.ofNullable(tx.getEntityType(entityTypeLabel));
            if (entityTypeOptional.isPresent()) {
                LOG.debug("postEntity - entityType " + entityTypeLabel + " found.");
                EntityType entityType = entityTypeOptional.get();
                Entity entity = entityType.addEntity();
                tx.commit();
                String jsonConceptId = entity.getId().getValue();
                LOG.debug("postEntity - entity " + jsonConceptId + " of entityType " + entityTypeLabel + " added. request processed");
                response.status(200);
                Json json = this.entityJson(jsonConceptId);
                return json;
            }
            LOG.debug("postEntity - entityType " + entityTypeLabel + " NOT found.");
            response.status(400);
            Json json = Json.nil();
            return json;
        }
    }

    private Json assignAttributeToEntity(Request request, Response response) {
        LOG.debug("assignAttributeToEntity - request received.");
        String entityConceptId = Requests.mandatoryPathParameter(request, ":entityConceptId");
        String attributeConceptId = Requests.mandatoryPathParameter(request, ":attributeConceptId");
        String keyspace = Requests.mandatoryQueryParameter(request, "keyspace");
        try (GraknTx tx = this.factory.tx(Keyspace.of((String)keyspace), GraknTxType.WRITE);){
            LOG.debug("assignAttributeToEntity - attempting to find attributeConceptId " + attributeConceptId + " and entityConceptId " + entityConceptId + ", in keyspace " + keyspace);
            Optional<Concept> entityOptional = Optional.ofNullable(tx.getConcept(ConceptId.of((String)entityConceptId)));
            Optional<Concept> attributeOptional = Optional.ofNullable(tx.getConcept(ConceptId.of((String)attributeConceptId)));
            if (entityOptional.isPresent() && attributeOptional.isPresent()) {
                LOG.debug("assignAttributeToEntity - entity and attribute found. attempting to assign attributeConceptId " + attributeConceptId + " to entityConceptId " + entityConceptId + ", in keyspace " + keyspace);
                Entity entity = (Entity)entityOptional.get();
                Attribute attribute = (Attribute)attributeOptional.get();
                entity.attribute(attribute);
                tx.commit();
                LOG.debug("assignAttributeToEntity - assignment succeeded. request processed.");
                Json responseBody = Json.object();
                response.status(200);
                Json json = responseBody;
                return json;
            }
            String entityInfo = entityOptional.map(e -> e.toString()).orElse("<empty>");
            String attributeInfo = attributeOptional.map(e -> e.toString()).orElse("<empty>");
            LOG.debug("assignAttributeToEntity - either entity (" + entityInfo + ") orattribute (" + attributeInfo + ") not found. request processed.");
            response.status(400);
            Json json = Json.nil();
            return json;
        }
    }

    private Json deleteAttributeToEntityAssignment(Request request, Response response) {
        LOG.debug("deleteAttributeToEntityAssignment - request received.");
        String entityConceptId = Requests.mandatoryPathParameter(request, ":entityConceptId");
        String attributeConceptId = Requests.mandatoryPathParameter(request, ":attributeConceptId");
        String keyspace = Requests.mandatoryQueryParameter(request, "keyspace");
        try (GraknTx tx = this.factory.tx(Keyspace.of((String)keyspace), GraknTxType.WRITE);){
            LOG.debug("deleteAttributeToEntityAssignment - attempting to find attributeConceptId " + attributeConceptId + " and entityConceptId " + entityConceptId + ", in keyspace " + keyspace);
            Optional<Concept> entityOptional = Optional.ofNullable(tx.getConcept(ConceptId.of((String)entityConceptId)));
            Optional<Concept> attributeOptional = Optional.ofNullable(tx.getConcept(ConceptId.of((String)attributeConceptId)));
            if (entityOptional.isPresent() && attributeOptional.isPresent()) {
                LOG.debug("deleteAttributeToEntityAssignment - entity and attribute found. attempting to assign attributeConceptId " + attributeConceptId + " to entityConceptId " + entityConceptId + ", in keyspace " + keyspace);
                Entity entity = (Entity)entityOptional.get();
                Attribute attribute = (Attribute)attributeOptional.get();
                entity.deleteAttribute(attribute);
                tx.commit();
                LOG.debug("deleteAttributeToEntityAssignment - deletion succeeded. request processed.");
                Json responseBody = Json.object();
                response.status(200);
                Json json = responseBody;
                return json;
            }
            String entityInfo = entityOptional.map(e -> e.toString()).orElse("<empty>");
            String attributeInfo = attributeOptional.map(e -> e.toString()).orElse("<empty>");
            LOG.debug("deleteAttributeToEntityAssignment - either entity (" + entityInfo + ") orattribute (" + attributeInfo + ") not found. request processed.");
            response.status(400);
            Json json = Json.nil();
            return json;
        }
    }

    private Json entityJson(String conceptId) {
        return Json.object((Object[])new Object[]{"entity", Json.object((Object[])new Object[]{"conceptId", conceptId})});
    }
}

