/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller.api;

import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.engine.controller.util.Requests;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import java.util.Optional;
import java.util.stream.Stream;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Service;

public class RelationshipTypeController {
    private final EngineGraknTxFactory factory;
    private static final Logger LOG = LoggerFactory.getLogger(RelationshipTypeController.class);

    public RelationshipTypeController(EngineGraknTxFactory factory, Service spark) {
        this.factory = factory;
        spark.get("/api/relationshipType/:relationshipTypeLabel", this::getRelationshipType);
        spark.post("/api/relationshipType", this::postRelationshipType);
    }

    private Json getRelationshipType(Request request, Response response) {
        LOG.debug("getRelationshipType - request received.");
        String relationshipTypeLabel = Requests.mandatoryPathParameter(request, ":relationshipTypeLabel");
        String keyspace = Requests.mandatoryQueryParameter(request, "keyspace");
        LOG.debug("getRelationshipType - attempting to find role " + relationshipTypeLabel + " in keyspace " + keyspace);
        try (GraknTx tx = this.factory.tx(Keyspace.of((String)keyspace), GraknTxType.READ);){
            Optional<RelationshipType> relationshipType = Optional.ofNullable(tx.getRelationshipType(relationshipTypeLabel));
            if (relationshipType.isPresent()) {
                String jsonConceptId = relationshipType.get().getId().getValue();
                String jsonRelationshipTypeLabel = relationshipType.get().getLabel().getValue();
                response.status(200);
                Json responseBody = this.relationshipTypeJson(jsonConceptId, jsonRelationshipTypeLabel);
                LOG.debug("getRelationshipType - relationshipType found - " + jsonConceptId + ", " + jsonRelationshipTypeLabel + ". request processed.");
                Json json = responseBody;
                return json;
            }
            response.status(400);
            LOG.debug("getRelationshipType - relationshipType NOT found. request processed.");
            Json json = Json.nil();
            return json;
        }
    }

    private Json postRelationshipType(Request request, Response response) {
        LOG.debug("postRelationshipType - request received.");
        Json requestBody = Json.read((String)Requests.mandatoryBody(request));
        String relationshipTypeLabel = Requests.extractJsonField(requestBody, "relationshipType", "label").asString();
        Stream<String> roleLabels = Requests.extractJsonField(requestBody, "relationshipType", "roles").asList().stream().map(e -> (String)e);
        String keyspace = Requests.mandatoryQueryParameter(request, "keyspace");
        LOG.debug("postRelationshipType - attempting to add a new relationshipType " + relationshipTypeLabel + " on keyspace " + keyspace);
        try (GraknTx tx = this.factory.tx(Keyspace.of((String)keyspace), GraknTxType.WRITE);){
            Json responseBody;
            RelationshipType relationshipType = tx.putRelationshipType(relationshipTypeLabel);
            roleLabels.forEach(roleLabel -> {
                Role role = tx.putRole(roleLabel);
                relationshipType.relates(role);
            });
            tx.commit();
            String jsonConceptId = relationshipType.getId().getValue();
            String jsonRelationshipTypeLabel = relationshipType.getLabel().getValue();
            LOG.debug("postRelationshipType - relationshipType " + jsonRelationshipTypeLabel + " with id " + jsonConceptId + " added. request processed.");
            response.status(200);
            Json json = responseBody = this.relationshipTypeJson(jsonConceptId, jsonRelationshipTypeLabel);
            return json;
        }
    }

    private Json relationshipTypeJson(String conceptId, String label) {
        return Json.object((Object[])new Object[]{"relationshipType", Json.object((Object[])new Object[]{"conceptId", conceptId, "label", label})});
    }
}

