/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller.api;

import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.concept.Role;
import ai.grakn.engine.controller.util.Requests;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import java.util.Optional;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Service;

public class RoleController {
    private final EngineGraknTxFactory factory;
    private static final Logger LOG = LoggerFactory.getLogger(RoleController.class);

    public RoleController(EngineGraknTxFactory factory, Service spark) {
        this.factory = factory;
        spark.get("/api/role/:roleLabel", this::getRole);
    }

    private Json getRole(Request request, Response response) {
        LOG.debug("getRole - request received.");
        String roleLabel = Requests.mandatoryPathParameter(request, ":roleLabel");
        String keyspace = Requests.mandatoryQueryParameter(request, "keyspace");
        LOG.debug("getRole - attempting to find role " + roleLabel + " in keyspace " + keyspace);
        try (GraknTx tx = this.factory.tx(Keyspace.of((String)keyspace), GraknTxType.READ);){
            Optional<Role> role = Optional.ofNullable(tx.getRole(roleLabel));
            if (role.isPresent()) {
                String jsonConceptId = role.get().getId().getValue();
                String jsonRoleLabel = role.get().getLabel().getValue();
                response.status(200);
                Json responseBody = this.roleJson(jsonConceptId, jsonRoleLabel);
                LOG.debug("getRole - role found - " + jsonConceptId + ", " + jsonRoleLabel + ". request processed.");
                Json json = responseBody;
                return json;
            }
            response.status(400);
            LOG.debug("getRole - role NOT found. request processed.");
            Json json = Json.nil();
            return json;
        }
    }

    private Json roleJson(String conceptId, String roleLabel) {
        return Json.object((Object[])new Object[]{"role", Json.object((Object[])new Object[]{"conceptId", conceptId, "label", roleLabel})});
    }
}

