/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller.api;

import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.concept.Rule;
import ai.grakn.engine.controller.util.Requests;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import java.util.Optional;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Service;

public class RuleController {
    private final EngineGraknTxFactory factory;
    private static final Logger LOG = LoggerFactory.getLogger(RuleController.class);

    public RuleController(EngineGraknTxFactory factory, Service spark) {
        this.factory = factory;
        spark.get("/api/rule/:ruleLabel", this::getRule);
        spark.post("/api/rule", this::postRule);
    }

    private Json getRule(Request request, Response response) {
        LOG.debug("getRule - request received.");
        String ruleLabel = Requests.mandatoryPathParameter(request, ":ruleLabel");
        String keyspace = Requests.mandatoryQueryParameter(request, "keyspace");
        LOG.debug("getRule - attempting to find rule " + ruleLabel + " in keyspace " + keyspace);
        try (GraknTx tx = this.factory.tx(Keyspace.of((String)keyspace), GraknTxType.READ);){
            Optional<Rule> rule = Optional.ofNullable(tx.getRule(ruleLabel));
            if (rule.isPresent()) {
                String jsonConceptId = rule.get().getId().getValue();
                String jsonRuleLabel = rule.get().getLabel().getValue();
                String jsonRuleWhen = rule.get().getWhen().toString();
                String jsonRuleThen = rule.get().getThen().toString();
                response.status(200);
                Json responseBody = this.ruleJson(jsonConceptId, jsonRuleLabel, jsonRuleWhen, jsonRuleThen);
                LOG.debug("getRule - rule found - " + jsonConceptId + ", " + jsonRuleLabel + ". request processed.");
                Json json = responseBody;
                return json;
            }
            response.status(400);
            LOG.debug("getRule - rule NOT found. request processed.");
            Json json = Json.nil();
            return json;
        }
    }

    private Json postRule(Request request, Response response) {
        LOG.debug("postRule - request received.");
        Json requestBody = Json.read((String)Requests.mandatoryBody(request));
        String ruleLabel = Requests.extractJsonField(requestBody, "rule", "label").asString();
        String when = Requests.extractJsonField(requestBody, "rule", "when").asString();
        String then = Requests.extractJsonField(requestBody, "rule", "then").asString();
        String keyspace = Requests.mandatoryQueryParameter(request, "keyspace");
        LOG.debug("postRule - attempting to add a new rule " + ruleLabel + " on keyspace " + keyspace);
        try (GraknTx tx = this.factory.tx(Keyspace.of((String)keyspace), GraknTxType.WRITE);){
            Json responseBody;
            Rule rule = tx.putRule(ruleLabel, tx.graql().parsePattern(when), tx.graql().parsePattern(then));
            tx.commit();
            String jsonConceptId = rule.getId().getValue();
            String jsonRuleLabel = rule.getLabel().getValue();
            String jsonRuleWhen = rule.getWhen().toString();
            String jsonRuleThen = rule.getThen().toString();
            LOG.debug("postRule - rule " + jsonRuleLabel + " with id " + jsonConceptId + " added. request processed.");
            response.status(200);
            Json json = responseBody = this.ruleJson(jsonConceptId, jsonRuleLabel, jsonRuleWhen, jsonRuleThen);
            return json;
        }
    }

    private Json ruleJson(String conceptId, String label, String when, String then) {
        return Json.object((Object[])new Object[]{"rule", Json.object((Object[])new Object[]{"conceptId", conceptId, "label", label, "when", when, "then", then})});
    }
}

