/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.factory;

import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.engine.SystemKeyspace;
import ai.grakn.factory.FactoryBuilder;
import java.util.Map;
import java.util.Properties;

public class EngineGraknTxFactory {
    private final Properties properties = new Properties();
    private final String engineURI;
    private final SystemKeyspace systemKeyspace;

    public static EngineGraknTxFactory createAndLoadSystemSchema(Properties properties) {
        return new EngineGraknTxFactory(properties, true);
    }

    public static EngineGraknTxFactory create(Properties properties) {
        return new EngineGraknTxFactory(properties, false);
    }

    private EngineGraknTxFactory(Properties properties, boolean loadSchema) {
        this.properties.putAll((Map<?, ?>)properties);
        this.engineURI = properties.getProperty("server.host") + ":" + properties.getProperty("server.port");
        this.systemKeyspace = new SystemKeyspace(this, loadSchema);
    }

    public synchronized void refreshConnections() {
        FactoryBuilder.refresh();
    }

    public GraknTx tx(String keyspace, GraknTxType type) {
        return this.tx(Keyspace.of((String)keyspace), type);
    }

    public GraknTx tx(Keyspace keyspace, GraknTxType type) {
        if (!keyspace.equals(SystemKeyspace.SYSTEM_KB_KEYSPACE)) {
            this.systemKeyspace.ensureKeyspaceInitialised(keyspace);
        }
        return FactoryBuilder.getFactory((Keyspace)keyspace, (String)this.engineURI, (Properties)this.properties).open(type);
    }

    public Properties properties() {
        return this.properties;
    }

    public SystemKeyspace systemKeyspace() {
        return this.systemKeyspace;
    }
}

