/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.postprocessing;

import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import ai.grakn.exception.GraknBackendException;
import ai.grakn.util.ErrorMessage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraknTxMutators {
    private static final Logger LOG = LoggerFactory.getLogger(GraknTxMutators.class);

    public static void runBatchMutationWithRetry(EngineGraknTxFactory factory, Keyspace keyspace, int maxRetry, Consumer<GraknTx> mutatingFunction) {
        GraknTxMutators.runMutationWithRetry(factory, keyspace, GraknTxType.BATCH, maxRetry, mutatingFunction);
    }

    static void runMutationWithRetry(EngineGraknTxFactory factory, Keyspace keyspace, int maxRetry, Consumer<GraknTx> mutatingFunction) {
        GraknTxMutators.runMutationWithRetry(factory, keyspace, GraknTxType.WRITE, maxRetry, mutatingFunction);
    }

    private static void runMutationWithRetry(EngineGraknTxFactory factory, Keyspace keyspace, GraknTxType txType, int maxRetry, Consumer<GraknTx> mutatingFunction) {
        if (!factory.systemKeyspace().containsKeyspace(keyspace)) {
            throw GraknBackendException.noSuchKeyspace((Keyspace)keyspace);
        }
        for (int retry = 0; retry < maxRetry; ++retry) {
            try (GraknTx graph = factory.tx(keyspace, txType);){
                mutatingFunction.accept(graph);
                return;
            }
            catch (GraknBackendException e) {
                LOG.debug(ErrorMessage.TX_MUTATION_ERROR.getMessage(new Object[]{e.getMessage()}), (Throwable)e);
                GraknTxMutators.performRetry(retry);
                continue;
            }
        }
        throw new RuntimeException(ErrorMessage.UNABLE_TO_MUTATE.getMessage(new Object[]{keyspace}));
    }

    private static void performRetry(int retry) {
        double seed = 1.0 + Math.random() * 5.0;
        double waitTime = (double)retry * 2.0 + seed;
        LOG.debug(ErrorMessage.BACK_OFF_RETRY.getMessage(new Object[]{waitTime}));
        try {
            Thread.sleep((long)Math.ceil(waitTime * 1000.0));
        }
        catch (InterruptedException e1) {
            LOG.error("Exception", (Throwable)e1);
        }
    }
}

