/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.tasks.manager;

import ai.grakn.engine.TaskId;
import ai.grakn.engine.TaskStatus;
import ai.grakn.engine.tasks.BackgroundTask;
import ai.grakn.engine.tasks.manager.TaskCheckpoint;
import ai.grakn.engine.tasks.manager.TaskSchedule;
import ai.grakn.engine.util.EngineID;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.time.Instant;
import org.apache.commons.lang.exception.ExceptionUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskState
implements Serializable {
    private static final long serialVersionUID = -7301340972479426653L;
    private final String taskId;
    private final Priority priority;
    private TaskStatus status;
    private Instant statusChangeTime;
    private final String taskClassName;
    private final String creator;
    private EngineID engineID;
    private TaskSchedule schedule;
    private String stackTrace;
    private String exception;
    private TaskCheckpoint taskCheckpoint;

    public static TaskState of(Class<?> taskClass, String creator, TaskSchedule schedule, Priority priority) {
        return new TaskState(taskClass, creator, schedule, TaskId.generate(), priority);
    }

    public static TaskState of(TaskId id) {
        return new TaskState(null, null, null, id, null);
    }

    public static TaskState of(TaskId id, TaskStatus taskStatus) {
        return new TaskState(null, null, null, id, null, taskStatus);
    }

    @JsonCreator
    public TaskState(@JsonProperty(value="taskClass") Class<?> taskClass, @JsonProperty(value="creator") String creator, @JsonProperty(value="schedule") TaskSchedule schedule, @JsonProperty(value="id") TaskId id, @JsonProperty(value="priority") Priority priority, @JsonProperty(value="status") TaskStatus status) {
        this.status = status;
        this.statusChangeTime = Instant.now();
        this.taskClassName = taskClass != null ? taskClass.getName() : null;
        this.creator = creator;
        this.schedule = schedule;
        this.taskId = id.getValue();
        this.priority = priority;
    }

    public TaskState(Class<?> taskClass, String creator, TaskSchedule schedule, TaskId id, Priority priority) {
        this(taskClass, creator, schedule, id, priority, TaskStatus.CREATED);
    }

    private TaskState(TaskState taskState) {
        this.taskId = taskState.taskId;
        this.status = taskState.status;
        this.statusChangeTime = taskState.statusChangeTime;
        this.taskClassName = taskState.taskClassName;
        this.creator = taskState.creator;
        this.engineID = taskState.engineID;
        this.schedule = taskState.schedule;
        this.stackTrace = taskState.stackTrace;
        this.exception = taskState.exception;
        this.taskCheckpoint = taskState.taskCheckpoint;
        this.priority = taskState.priority;
    }

    @JsonProperty(value="id")
    public TaskId getId() {
        return TaskId.of((String)this.taskId);
    }

    public TaskState markRunning(EngineID engineID) {
        this.status = TaskStatus.RUNNING;
        this.engineID = engineID;
        this.statusChangeTime = Instant.now();
        return this;
    }

    public TaskState markCompleted() {
        this.status = TaskStatus.COMPLETED;
        this.statusChangeTime = Instant.now();
        this.taskCheckpoint = null;
        return this;
    }

    public TaskState markScheduled() {
        this.status = TaskStatus.SCHEDULED;
        this.statusChangeTime = Instant.now();
        return this;
    }

    public TaskState markStopped() {
        this.status = TaskStatus.STOPPED;
        this.statusChangeTime = Instant.now();
        return this;
    }

    public TaskState markFailed(Throwable exception) {
        this.status = TaskStatus.FAILED;
        this.exception = exception.getClass().getName();
        this.stackTrace = ExceptionUtils.getFullStackTrace((Throwable)exception);
        this.statusChangeTime = Instant.now();
        return this;
    }

    public TaskState markFailed(String reason) {
        this.status = TaskStatus.FAILED;
        this.exception = reason;
        this.stackTrace = "No Stack Trace Provided";
        this.statusChangeTime = Instant.now();
        return this;
    }

    public TaskStatus status() {
        return this.status;
    }

    public Instant statusChangeTime() {
        return this.statusChangeTime;
    }

    public Class<? extends BackgroundTask> taskClass() {
        try {
            return Class.forName(this.taskClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String creator() {
        return this.creator;
    }

    @JsonProperty(value="creator")
    public String getCreator() {
        return this.creator;
    }

    public EngineID engineID() {
        return this.engineID;
    }

    public TaskSchedule schedule() {
        return this.schedule;
    }

    @JsonProperty(value="schedule")
    public TaskSchedule getSchedule() {
        return this.schedule;
    }

    public TaskState schedule(TaskSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public String stackTrace() {
        return this.stackTrace;
    }

    public String exception() {
        return this.exception;
    }

    public TaskState checkpoint(TaskCheckpoint taskCheckpoint) {
        this.taskCheckpoint = taskCheckpoint;
        return this;
    }

    public Priority priority() {
        return this.priority;
    }

    public TaskCheckpoint checkpoint() {
        return this.taskCheckpoint;
    }

    public TaskState copy() {
        return new TaskState(this);
    }

    @JsonProperty(value="serialVersionUID")
    public static long getSerialVersionUID() {
        return -7301340972479426653L;
    }

    @JsonProperty(value="priority")
    public Priority getPriority() {
        return this.priority;
    }

    @JsonProperty(value="status")
    public TaskStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="taskClassName")
    public String getTaskClassName() {
        return this.taskClassName;
    }

    @JsonProperty(value="engineId")
    public EngineID getEngineID() {
        return this.engineID;
    }

    @JsonProperty(value="taskCheckpoint")
    public TaskCheckpoint getTaskCheckpoint() {
        return this.taskCheckpoint;
    }

    public String toString() {
        return "TaskState(" + this.taskClass().getSimpleName() + ", \"" + this.getId() + "\").status(" + this.status() + ")";
    }

    public static enum Priority {
        LOW,
        HIGH;


        public String queue() {
            return this.name() + "-priority-queue";
        }
    }
}

