/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.tasks.manager.redisqueue;

import ai.grakn.engine.GraknEngineConfig;
import ai.grakn.engine.TaskStatus;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import ai.grakn.engine.lock.LockProvider;
import ai.grakn.engine.tasks.BackgroundTask;
import ai.grakn.engine.tasks.connection.RedisCountStorage;
import ai.grakn.engine.tasks.manager.TaskCheckpoint;
import ai.grakn.engine.tasks.manager.TaskConfiguration;
import ai.grakn.engine.tasks.manager.TaskState;
import ai.grakn.engine.tasks.manager.TaskStateStorage;
import ai.grakn.engine.tasks.manager.redisqueue.RedisTaskManager;
import ai.grakn.engine.tasks.manager.redisqueue.Task;
import ai.grakn.engine.util.EngineID;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class RedisTaskQueueConsumer
implements Consumer<Task> {
    private static final Logger LOG = LoggerFactory.getLogger(RedisTaskQueueConsumer.class);
    private RedisTaskManager redisTaskManager;
    private EngineID engineId;
    private GraknEngineConfig config;
    private RedisCountStorage redisCountStorage;
    private MetricRegistry metricRegistry;
    private EngineGraknTxFactory factory;
    private LockProvider lockProvider;

    public RedisTaskQueueConsumer(RedisTaskManager redisTaskManager, EngineID engineId, GraknEngineConfig config, RedisCountStorage redisCountStorage, MetricRegistry metricRegistry, EngineGraknTxFactory factory, LockProvider lockProvider) {
        this.redisTaskManager = redisTaskManager;
        this.engineId = engineId;
        this.config = config;
        this.redisCountStorage = redisCountStorage;
        this.metricRegistry = metricRegistry;
        this.factory = factory;
        this.lockProvider = lockProvider;
    }

    private void checkPreconditions() {
        try {
            Preconditions.checkNotNull((Object)this.metricRegistry);
            Preconditions.checkNotNull((Object)this.engineId);
            Preconditions.checkNotNull((Object)this.config);
            Preconditions.checkNotNull((Object)this.redisCountStorage);
            Preconditions.checkNotNull((Object)this.redisTaskManager);
            Preconditions.checkNotNull((Object)this.lockProvider);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException(String.format("%s was started but the state wasn't set explicitly", this.getClass().getName()));
        }
    }

    private boolean taskShouldRecur(TaskState taskState) {
        return taskState.schedule().isRecurring() && !taskState.status().equals((Object)TaskStatus.FAILED) && !taskState.status().equals((Object)TaskStatus.STOPPED);
    }

    private boolean taskShouldResume(Task task) {
        return task.getTaskState().status() == TaskStatus.RUNNING;
    }

    private Consumer<TaskCheckpoint> saveCheckpoint(TaskState taskState, TaskStateStorage storage) {
        return checkpoint -> storage.updateState(taskState.checkpoint((TaskCheckpoint)checkpoint));
    }

    @Override
    public void accept(Task task) {
        this.checkPreconditions();
        Timer executeTimer = this.metricRegistry.timer(MetricRegistry.name(RedisTaskQueueConsumer.class, (String[])new String[]{"execute"}));
        Timer.Context context = executeTimer.time();
        TaskState taskState = task.getTaskState();
        TaskConfiguration taskConfiguration = task.getTaskConfiguration();
        try {
            BackgroundTask runningTask = taskState.taskClass().newInstance();
            runningTask.initialize(this.saveCheckpoint(taskState, this.redisTaskManager.storage()), taskConfiguration, this.redisTaskManager, this.config, this.redisCountStorage, this.factory, this.lockProvider, this.metricRegistry);
            this.metricRegistry.meter(MetricRegistry.name(RedisTaskQueueConsumer.class, (String[])new String[]{"initialized"})).mark();
            if (this.taskShouldResume(task)) {
                throw new NotImplementedException();
            }
            runningTask.start();
            this.metricRegistry.meter(MetricRegistry.name(RedisTaskQueueConsumer.class, (String[])new String[]{"run"})).mark();
            if (this.taskShouldRecur(taskState)) {
                throw new NotImplementedException();
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.metricRegistry.meter(MetricRegistry.name(RedisTaskQueueConsumer.class, (String[])new String[]{"failed"})).mark();
            LOG.error("{} had an instantiantion exception", (Object)task.getTaskState().getId(), (Object)e);
            throw new RuntimeException(e);
        }
        catch (RuntimeException throwable) {
            this.metricRegistry.meter(MetricRegistry.name(RedisTaskQueueConsumer.class, (String[])new String[]{"failed"})).mark();
            LOG.error("{} could not be completed successfully", (Object)task.getTaskState().getId(), (Object)throwable);
            throw new RuntimeException(throwable);
        }
        finally {
            context.stop();
        }
    }
}

