/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.tasks.manager.redisqueue;

import ai.grakn.engine.TaskId;
import ai.grakn.engine.TaskStatus;
import ai.grakn.engine.tasks.manager.TaskState;
import ai.grakn.engine.tasks.manager.TaskStateStorage;
import ai.grakn.engine.tasks.manager.redisqueue.Task;
import ai.grakn.engine.util.EngineID;
import ai.grakn.exception.GraknBackendException;
import ai.grakn.redisq.Redisq;
import ai.grakn.redisq.State;
import ai.grakn.redisq.StateInfo;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisTaskStorage
implements TaskStateStorage {
    private static final Logger LOG = LoggerFactory.getLogger(RedisTaskStorage.class);
    private final Meter writeError;
    private Redisq<Task> redis;

    private RedisTaskStorage(Redisq<Task> redis, MetricRegistry metricRegistry) {
        this.redis = redis;
        this.writeError = metricRegistry.meter(MetricRegistry.name(RedisTaskStorage.class, (String[])new String[]{"write", "error"}));
    }

    public static RedisTaskStorage create(Redisq<Task> redisq, MetricRegistry metricRegistry) {
        return new RedisTaskStorage(redisq, metricRegistry);
    }

    private State mapStatus(TaskStatus status) {
        return status.asStateInfo();
    }

    @Override
    public TaskId newState(TaskState state) throws GraknBackendException {
        this.updateState(state);
        return state.getId();
    }

    @Override
    public Boolean updateState(TaskState state) {
        try {
            this.redis.setState(state.getId().getValue(), this.mapStatus(state.status()));
            return true;
        }
        catch (RuntimeException e) {
            this.writeError.mark();
            LOG.error("Could not update state", (Throwable)e);
            return false;
        }
    }

    @Override
    @Nullable
    public TaskState getState(TaskId id) throws GraknBackendException {
        Optional state = this.redis.getState(id.getValue());
        if (!state.isPresent()) {
            throw GraknBackendException.stateStorage();
        }
        TaskState taskState = TaskState.of(id, TaskStatus.fromState((State)((StateInfo)state.get()).getState()));
        if (taskState.status().equals((Object)TaskStatus.FAILED)) {
            String info = ((StateInfo)state.get()).getInfo();
            taskState.markFailed(info);
        }
        return taskState;
    }

    @Override
    public boolean containsTask(TaskId id) {
        return this.redis.getState(id.getValue()).isPresent();
    }

    @Override
    public Set<TaskState> getTasks(@Nullable TaskStatus taskStatus, @Nullable String taskClassName, @Nullable String createdBy, @Nullable EngineID runningOnEngine, int limit, int offset) {
        Stream<TaskState> stream = this.redis.getStates().filter(Optional::isPresent).map(Optional::get).map(s -> TaskState.of(TaskId.of((String)s.getId()), TaskStatus.fromState((State)s.getStateInfo().getState())));
        if (taskStatus != null) {
            stream = stream.filter(t -> t.status().equals((Object)taskStatus));
        }
        if (taskClassName != null) {
            LOG.warn("Asked for taskClassName filter but not implemented");
        }
        if (createdBy != null) {
            LOG.warn("Asked for createdBy filter but not implemented");
        }
        if (runningOnEngine != null) {
            LOG.warn("Asked for runningOnEngine filter but not implemented");
        }
        stream = stream.skip(offset);
        if (limit > 0) {
            stream = stream.limit(limit);
        }
        Set<TaskState> results = stream.collect(Collectors.toSet());
        LOG.debug("getTasks returning {} results", (Object)results.size());
        return results;
    }

    @Override
    public void clear() {
    }
}

