/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.user;

import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Label;
import ai.grakn.engine.SystemKeyspace;
import ai.grakn.engine.factory.EngineGraknTxFactory;
import ai.grakn.engine.user.Password;
import ai.grakn.engine.user.UsersHandler;
import ai.grakn.engine.util.ExceptionWrapper;
import ai.grakn.graql.GetQuery;
import ai.grakn.graql.Graql;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Answer;
import ai.grakn.util.Schema;
import java.util.List;
import java.util.Map;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemKeyspaceUsers
extends UsersHandler {
    private final Logger LOG = LoggerFactory.getLogger(SystemKeyspaceUsers.class);
    private final EngineGraknTxFactory factory;

    SystemKeyspaceUsers(String adminPassword, EngineGraknTxFactory factory) {
        super(adminPassword);
        this.factory = factory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean addUser(Json userJson) {
        String username = userJson.at("user-name").asString();
        if (this.userExists(username)) {
            return false;
        }
        try (GraknTx graph = this.factory.tx(SystemKeyspace.SYSTEM_KB_KEYSPACE, GraknTxType.WRITE);){
            VarPattern user = Graql.var().isa("user");
            for (Map.Entry entry : userJson.asJsonMap().entrySet()) {
                String property = (String)entry.getKey();
                Json value = (Json)entry.getValue();
                if (property.equals("user-password")) {
                    byte[] salt = Password.getNextSalt(graph);
                    byte[] hashedPassword = Password.hash(value.getValue().toString().toCharArray(), salt);
                    user = user.has("user-password", (Object)Password.getString(hashedPassword));
                    user = user.has("user-password-salt", (Object)Password.getString(salt));
                    continue;
                }
                user = user.has(property, value.getValue());
            }
            InsertQuery query = graph.graql().insert(new VarPattern[]{user});
            query.execute();
            graph.commit();
            this.LOG.debug("Created user " + userJson);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            this.LOG.error("Could not add user " + userJson + " to system graph: ", t);
            ExceptionWrapper.rethrow(t);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean userExists(String username) {
        if (this.superUsername().equals(username)) {
            return true;
        }
        try (GraknTx graph = this.factory.tx(SystemKeyspace.SYSTEM_KB_KEYSPACE, GraknTxType.READ);){
            VarPattern lookup = Graql.var().isa("user").has("user-name", (Object)username);
            boolean bl = graph.graql().match(new Pattern[]{lookup}).iterator().hasNext();
            return bl;
        }
        catch (Throwable t) {
            this.LOG.error("While getting all users.", t);
            ExceptionWrapper.rethrow(t);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Json getUser(String username) {
        if (this.superUsername().equals(username)) {
            return Json.object((Object[])new Object[]{"user-name", username});
        }
        try (GraknTx graph = this.factory.tx(SystemKeyspace.SYSTEM_KB_KEYSPACE, GraknTxType.READ);){
            VarPattern lookup = Graql.var((String)"entity").isa("user").has("user-name", (Object)username);
            Var resource = Graql.var((String)"property");
            GetQuery query = graph.graql().match(new Pattern[]{lookup.has(Schema.MetaSchema.ATTRIBUTE.getLabel(), (VarPattern)resource)}).get();
            List L = (List)query.execute();
            if (L.isEmpty()) {
                Json json2 = Json.nil();
                return json2;
            }
            Json user = Json.object();
            L.forEach(property -> {
                Label label = property.get(resource).asThing().type().getLabel();
                Object value = property.get(resource).asAttribute().getValue();
                user.set(label.getValue(), value);
            });
            Json json = user;
            return json;
        }
        catch (Throwable t) {
            this.LOG.error("While getting all users.", t);
            ExceptionWrapper.rethrow(t);
            return Json.nil();
        }
    }

    @Override
    public boolean validateUser(String username, String passwordClient) {
        if (this.superUsername().equals(username)) {
            return passwordClient.equals(this.adminPassword);
        }
        try (GraknTx graph = this.factory.tx(SystemKeyspace.SYSTEM_KB_KEYSPACE, GraknTxType.READ);){
            List results = (List)graph.graql().match(new Pattern[]{Graql.var((String)"salt").isa("user-password-salt"), Graql.var((String)"stored-password").isa("user-password"), Graql.var((String)"entity").isa("user").has("user-name", (Object)username).has("user-password", (VarPattern)Graql.var((String)"stored-password")).has("user-password-salt", (VarPattern)Graql.var((String)"salt"))}).get().execute();
            if (!results.isEmpty()) {
                Concept saltConcept = ((Answer)results.get(0)).get("salt");
                Concept passwordConcept = ((Answer)results.get(0)).get("stored-password");
                if (saltConcept != null && passwordConcept != null && saltConcept.isAttribute() && passwordConcept.isAttribute()) {
                    byte[] salt = Password.getBytes(saltConcept.asAttribute().getValue().toString());
                    byte[] expectedPassword = Password.getBytes(passwordConcept.asAttribute().getValue().toString());
                    boolean bl = Password.isExpectedPassword(passwordClient.toCharArray(), salt, expectedPassword);
                    return bl;
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Json allUsers(int offset, int limit) {
        try (GraknTx graph = this.factory.tx(SystemKeyspace.SYSTEM_KB_KEYSPACE, GraknTxType.READ);){
            VarPattern lookup = Graql.var((String)"entity").isa("user");
            GetQuery query = graph.graql().match(new Pattern[]{lookup.has("user-name", (VarPattern)Graql.var((String)"username"))}).limit((long)limit).offset((long)offset).get();
            List L = (List)query.execute();
            Json all = Json.array();
            L.forEach(concepts -> {
                String username = concepts.get("username").asAttribute().getValue().toString();
                all.add(this.getUser(username));
            });
            Json json = all;
            return json;
        }
        catch (Throwable t) {
            this.LOG.error("While getting all users.", t);
            ExceptionWrapper.rethrow(t);
            return Json.nil();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean removeUser(String username) {
        VarPattern lookup = Graql.var((String)"entity").isa("user").has("user-name", (Object)username);
        try (GraknTx graph = this.factory.tx(SystemKeyspace.SYSTEM_KB_KEYSPACE, GraknTxType.WRITE);){
            GetQuery query = graph.graql().match(new Pattern[]{lookup}).get();
            List results = (List)query.execute();
            boolean exists = !results.isEmpty();
            results.forEach(map -> map.forEach((k, v) -> {
                v.asThing().attributes(new AttributeType[0]).forEach(Concept::delete);
                v.delete();
            }));
            if (exists) {
                graph.commit();
            }
            boolean bl = exists;
            return bl;
        }
        catch (Throwable t) {
            this.LOG.error("While getting all users.", t);
            ExceptionWrapper.rethrow(t);
            return false;
        }
    }

    @Override
    public boolean updateUser(Json user) {
        throw new UnsupportedOperationException();
    }
}

