/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.util;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineID
implements Serializable {
    private static final long serialVersionUID = 8846772120873129437L;
    private static final Logger LOG = LoggerFactory.getLogger(EngineID.class);
    private final String value;

    private EngineID(String value) {
        this.value = value;
    }

    public static EngineID of(String value) {
        return new EngineID(value);
    }

    public static EngineID me() {
        String hostName = "";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Could not get system hostname: ", (Throwable)e);
        }
        String value = hostName + "-" + UUID.randomUUID().toString();
        return EngineID.of(value);
    }

    public String value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EngineID engineID = (EngineID)o;
        return this.value.equals(engineID.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return StringEscapeUtils.escapeJava((String)this.value);
    }
}

