/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine;

import ai.grakn.GraknGraph;
import ai.grakn.engine.controller.CommitLogController;
import ai.grakn.engine.controller.GraphFactoryController;
import ai.grakn.engine.controller.ImportController;
import ai.grakn.engine.controller.RemoteShellController;
import ai.grakn.engine.controller.StatusController;
import ai.grakn.engine.controller.TasksController;
import ai.grakn.engine.controller.TransactionController;
import ai.grakn.engine.controller.VisualiserController;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.exception.GraknEngineServerException;
import ai.grakn.exception.GraknValidationException;
import ai.grakn.factory.GraphFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Spark;
import spark.utils.IOUtils;

public class GraknEngineServer {
    private static ConfigProperties prop = ConfigProperties.getInstance();
    private static Logger LOG = null;

    public static void main(String[] args) {
        GraknEngineServer.start();
    }

    public static void start() {
        LOG = LoggerFactory.getLogger(GraknEngineServer.class);
        Spark.ipAddress((String)prop.getProperty("server.host"));
        Spark.port((int)prop.getPropertyAsInt("server.port"));
        Spark.staticFiles.externalLocation(prop.getPath("server.static-file-dir"));
        new RemoteShellController();
        new VisualiserController();
        new GraphFactoryController();
        new ImportController();
        new CommitLogController();
        new TransactionController();
        new StatusController();
        new TasksController();
        Spark.exception(GraknEngineServerException.class, (e, request, response) -> {
            response.status(((GraknEngineServerException)e).getStatus());
            response.body("New exception: " + e.getMessage() + " - Please refer to grakn.log file for full stack trace.");
        });
        GraknEngineServer.loadSystemOntology();
        Spark.awaitInitialization();
        GraknEngineServer.printStartMessage(prop.getProperty("server.host"), prop.getProperty("server.port"), prop.getLogFilePath());
    }

    public static void stop() {
        Spark.stop();
    }

    public static boolean isRunning() {
        try {
            String host = prop.getProperty("server.host");
            String port = prop.getProperty("server.port");
            HttpURLConnection connection = (HttpURLConnection)new URL("http://" + host + ":" + port + "/graph_factory").openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            InputStream inputStream = connection.getInputStream();
            if (inputStream.available() == 0) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static void printStartMessage(String host, String port, String logFilePath) {
        String address = "http://" + host + ":" + port;
        LOG.info("\nGrakn LOG file located at [" + logFilePath + "]");
        LOG.info("\n==================================================");
        LOG.info("\n" + String.format("     ___  ___  ___  _  __ _  _     ___  ___     \n    / __|| _ \\/   \\| |/ /| \\| |   /   \\|_ _|    \n   | (_ ||   /| - || ' < | .` | _ | - | | |     \n    \\___||_|_\\|_|_||_|\\_\\|_|\\_|(_)|_|_||___|   \n\n Web Dashboard available at [%s]", address));
        LOG.info("\n==================================================");
    }

    private static void loadSystemOntology() {
        GraknGraph graph = GraphFactory.getInstance().getGraph("graknSystem");
        ClassLoader loader = GraknEngineServer.class.getClassLoader();
        try {
            String query = IOUtils.toString((InputStream)loader.getResourceAsStream("system.gql"));
            graph.graql().parse(query).execute();
            graph.commit();
        }
        catch (GraknValidationException | IOException | NullPointerException e) {
            LOG.error("Could not load system ontology. The error was: " + e);
        }
    }
}

