/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.backgroundtasks;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Instance;
import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.engine.backgroundtasks.StateStorage;
import ai.grakn.engine.backgroundtasks.TaskState;
import ai.grakn.engine.backgroundtasks.TaskStatus;
import ai.grakn.exception.GraknValidationException;
import ai.grakn.factory.GraphFactory;
import ai.grakn.graql.Graql;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Var;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.util.Pair;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraknStateStorage
implements StateStorage {
    private static final String TASK_VAR = "task";
    private final Logger LOG = LoggerFactory.getLogger(GraknStateStorage.class);
    private GraknGraph graph = GraphFactory.getInstance().getGraph("graknSystem");

    @Override
    public String newState(String taskName, String createdBy, Date runAt, Boolean recurring, long interval, JSONObject configuration) {
        if (taskName == null || createdBy == null || runAt == null || recurring == null) {
            return null;
        }
        Var state = Graql.var((String)TASK_VAR).isa("scheduled-task").has("status", (Object)TaskStatus.CREATED.toString()).has("task-class-name", (Object)taskName).has("created-by", (Object)createdBy).has("run-at", (Object)runAt.getTime()).has("recurring", (Object)recurring).has("recur-interval", (Object)interval);
        if (configuration != null) {
            state.has("task-configuration", (Object)configuration.toString());
        }
        this.graph.graql().insert(new Var[]{state}).execute();
        try {
            this.graph.commit();
        }
        catch (GraknValidationException e) {
            this.LOG.error("Could not commit task to graph: " + e.getMessage());
            return null;
        }
        return ((Map)this.graph.graql().match(new Pattern[]{state}).execute().get(0)).values().stream().findFirst().map(Concept::getId).orElse(null);
    }

    @Override
    public void updateState(String id, TaskStatus status, String statusChangeBy, String executingHostname, Throwable failure, String checkpoint, JSONObject configuration) {
        if (id == null) {
            return;
        }
        if (status == null && statusChangeBy == null && executingHostname == null && failure == null && checkpoint == null && configuration == null) {
            return;
        }
        Var deleters = Graql.var((String)TASK_VAR);
        Var resources = Graql.var((String)TASK_VAR).id(id);
        if (status != null) {
            deleters.has("status").has("status-change-time");
            resources.has("status", (Object)status.toString()).has("status-change-time", (Object)new Date().getTime());
        }
        if (statusChangeBy != null) {
            deleters.has("status-change-by");
            resources.has("status-change-by", (Object)statusChangeBy);
        }
        if (executingHostname != null) {
            deleters.has("executing-hostname");
            resources.has("executing-hostname", (Object)executingHostname);
        }
        if (failure != null) {
            deleters.has("task-exception").has("stack-trace");
            resources.has("task-exception", (Object)failure.toString());
            if (failure.getStackTrace().length > 0) {
                resources.has("stack-trace", (Object)Arrays.toString(failure.getStackTrace()));
            }
        }
        if (checkpoint != null) {
            deleters.has("task-checkpoint");
            resources.has("task-checkpoint", (Object)checkpoint);
        }
        if (configuration != null) {
            deleters.has("task-configuration");
            resources.has("task-configuration", (Object)configuration.toString());
        }
        this.graph.graql().match(new Pattern[]{Graql.var((String)TASK_VAR).id(id)}).delete(new Var[]{deleters}).execute();
        this.graph.graql().insert(new Var[]{resources}).execute();
        try {
            this.graph.commit();
        }
        catch (GraknValidationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public TaskState getState(String id) {
        if (id == null) {
            return null;
        }
        Instance instance = this.graph.getInstance(id);
        Resource name = instance.resources(new ResourceType[]{this.graph.getResourceType("task-class-name")}).stream().findFirst().orElse(null);
        if (name == null) {
            this.LOG.error("Could not get 'task-class-name' for " + id);
            return null;
        }
        TaskState state = new TaskState(name.getValue().toString());
        List resources = this.graph.graql().match(new Pattern[]{Graql.var().rel(Graql.var().id(id)).rel(Graql.var((String)"r").isa(Graql.var().isa("resource-type")))}).select(new String[]{"r"}).execute();
        resources.forEach(x -> x.values().forEach(y -> {
            Resource r = y.asResource();
            this.buildState(state, r.type().getId(), r.getValue());
        }));
        return state;
    }

    @Override
    public Set<Pair<String, TaskState>> getTasks(TaskStatus taskStatus, String taskClassName, String createdBy, int limit, int offset) {
        Var matchVar = Graql.var((String)TASK_VAR).isa("scheduled-task");
        if (taskStatus != null) {
            matchVar.has("status", (Object)taskStatus.toString());
        }
        if (taskClassName != null) {
            matchVar.has("task-class-name", (Object)taskClassName);
        }
        if (createdBy != null) {
            matchVar.has("created-by", (Object)createdBy);
        }
        MatchQuery q = this.graph.graql().match(new Pattern[]{matchVar});
        if (limit > 0) {
            q.limit((long)limit);
        }
        if (offset > 0) {
            q.offset((long)offset);
        }
        List res = q.execute();
        HashSet<Pair<String, TaskState>> out = new HashSet<Pair<String, TaskState>>();
        for (Map m : res) {
            Concept c = m.values().stream().findFirst().orElse(null);
            if (c == null) continue;
            String id = c.getId();
            out.add((Pair<String, TaskState>)new Pair((Object)id, (Object)this.getState(id)));
        }
        return out;
    }

    private TaskState buildState(TaskState state, String resourceName, Object resourceValue) {
        switch (resourceName) {
            case "status": {
                state.status(TaskStatus.valueOf(resourceValue.toString()));
                break;
            }
            case "status-change-time": {
                state.statusChangeTime(new Date((Long)resourceValue));
                break;
            }
            case "status-change-by": {
                state.statusChangedBy(resourceValue.toString());
                break;
            }
            case "task-class-name": {
                break;
            }
            case "created-by": {
                state.creator(resourceValue.toString());
                break;
            }
            case "executing-hostname": {
                state.executingHostname(resourceValue.toString());
                break;
            }
            case "run-at": {
                state.runAt(new Date((Long)resourceValue));
                break;
            }
            case "recurring": {
                state.isRecurring((Boolean)resourceValue);
                break;
            }
            case "recur-interval": {
                state.interval((Long)resourceValue);
                break;
            }
            case "task-exception": {
                state.exception(resourceValue.toString());
                break;
            }
            case "stack-trace": {
                state.stackTrace(resourceValue.toString());
                break;
            }
            case "task-checkpoint": {
                state.checkpoint(resourceValue.toString());
                break;
            }
            case "task-configuration": {
                state.configuration(new JSONObject(resourceValue.toString()));
                break;
            }
            default: {
                this.LOG.error("Unknown resource type when deserialising TaskState: " + resourceName);
            }
        }
        return state;
    }
}

