/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.backgroundtasks;

import ai.grakn.engine.backgroundtasks.StateStorage;
import ai.grakn.engine.backgroundtasks.TaskState;
import ai.grakn.engine.backgroundtasks.TaskStatus;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javafx.util.Pair;
import org.json.JSONObject;

public class InMemoryStateStorage
implements StateStorage {
    private static InMemoryStateStorage instance = null;
    private Map<String, TaskState> storage = new ConcurrentHashMap<String, TaskState>();

    private InMemoryStateStorage() {
    }

    public static synchronized InMemoryStateStorage getInstance() {
        if (instance == null) {
            instance = new InMemoryStateStorage();
        }
        return instance;
    }

    @Override
    public String newState(String taskName, String createdBy, Date runAt, Boolean recurring, long interval, JSONObject configuration) {
        if (taskName == null || createdBy == null || runAt == null || recurring == null) {
            return null;
        }
        TaskState state = new TaskState(taskName);
        state.creator(createdBy).runAt(runAt).isRecurring(recurring).interval(interval);
        if (configuration != null) {
            state.configuration(configuration);
        } else {
            state.configuration(new JSONObject());
        }
        String id = UUID.randomUUID().toString();
        this.storage.put(id, state);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateState(String id, TaskStatus status, String statusChangeBy, String executingHostname, Throwable failure, String checkpoint, JSONObject configuration) {
        TaskState state;
        if (id == null) {
            return;
        }
        if (status == null && statusChangeBy == null && executingHostname == null && failure == null && checkpoint == null && configuration == null) {
            return;
        }
        TaskState taskState = state = this.storage.get(id);
        synchronized (taskState) {
            state.status(status);
            if (statusChangeBy != null) {
                state.statusChangedBy(statusChangeBy);
            }
            if (executingHostname != null) {
                state.executingHostname(executingHostname);
            }
            if (failure != null) {
                state.exception(failure.toString()).stackTrace(Arrays.toString(failure.getStackTrace()));
            }
            if (checkpoint != null) {
                state.checkpoint(checkpoint);
            }
            if (configuration != null) {
                state.configuration(configuration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskState getState(String id) {
        if (id == null || !this.storage.containsKey(id)) {
            return null;
        }
        TaskState state = this.storage.get(id);
        TaskState newState = null;
        TaskState taskState = state;
        synchronized (taskState) {
            try {
                newState = state.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return newState;
    }

    @Override
    public Set<Pair<String, TaskState>> getTasks(TaskStatus taskStatus, String taskClassName, String createdBy, int limit, int offset) {
        HashSet<Pair<String, TaskState>> res = new HashSet<Pair<String, TaskState>>();
        int count = 0;
        for (Map.Entry<String, TaskState> x : this.storage.entrySet()) {
            TaskState state = x.getValue();
            if (taskStatus != null && state.status() != taskStatus || taskClassName != null && !Objects.equals(state.taskClassName(), taskClassName) || createdBy != null && !Objects.equals(state.creator(), createdBy)) continue;
            if (count < offset) {
                ++count;
                continue;
            }
            if (limit > 0 && count >= limit + offset) break;
            ++count;
            res.add((Pair<String, TaskState>)new Pair((Object)x.getKey(), (Object)state));
        }
        return res;
    }
}

