/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.backgroundtasks;

import ai.grakn.engine.backgroundtasks.BackgroundTask;
import ai.grakn.engine.backgroundtasks.InMemoryStateStorage;
import ai.grakn.engine.backgroundtasks.StateStorage;
import ai.grakn.engine.backgroundtasks.TaskManager;
import ai.grakn.engine.backgroundtasks.TaskState;
import ai.grakn.engine.backgroundtasks.TaskStatus;
import ai.grakn.engine.util.ConfigProperties;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import javafx.util.Pair;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryTaskManager
implements TaskManager {
    private static String RUN_ONCE_NAME = "One off task scheduler.";
    private static String RUN_RECURRING_NAME = "Recurring task scheduler.";
    private static String EXCEPTION_CATCHER_NAME = "Task Exception Catcher.";
    private static String SAVE_CHECKPOINT_NAME = "Save task checkpoint.";
    private static InMemoryTaskManager instance = null;
    private final Logger LOG = LoggerFactory.getLogger(InMemoryTaskManager.class);
    private Map<String, Pair<ScheduledFuture<?>, BackgroundTask>> instantiatedTasks = new ConcurrentHashMap();
    private StateStorage stateStorage = InMemoryStateStorage.getInstance();
    private ReentrantLock stateUpdateLock = new ReentrantLock();
    private ExecutorService executorService;
    private ScheduledExecutorService schedulingService;

    private InMemoryTaskManager() {
        ConfigProperties properties = ConfigProperties.getInstance();
        this.schedulingService = Executors.newScheduledThreadPool(1);
        this.executorService = Executors.newFixedThreadPool(properties.getAvailableThreads());
    }

    public static synchronized InMemoryTaskManager getInstance() {
        if (instance == null) {
            instance = new InMemoryTaskManager();
        }
        return instance;
    }

    @Override
    public String scheduleTask(BackgroundTask task, String createdBy, Date runAt, long period, JSONObject configuration) {
        Boolean recurring = period != 0L;
        String id = this.stateStorage.newState(task.getClass().getName(), createdBy, runAt, recurring, period, configuration);
        Date now = new Date();
        long delay = now.getTime() - runAt.getTime();
        try {
            this.stateStorage.updateState(id, TaskStatus.SCHEDULED, this.getClass().getName(), null, null, null, null);
            ScheduledFuture<?> future = recurring != false ? this.schedulingService.scheduleAtFixedRate(this.runTask(id, task, true), delay, period, TimeUnit.MILLISECONDS) : this.schedulingService.schedule(this.runTask(id, task, false), delay, TimeUnit.MILLISECONDS);
            this.instantiatedTasks.put(id, new Pair(future, (Object)task));
        }
        catch (Throwable t) {
            this.stateStorage.updateState(id, TaskStatus.FAILED, this.getClass().getName(), null, t, null, null);
            this.instantiatedTasks.remove(id);
            return null;
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskManager stopTask(String id, String requesterName) {
        this.stateUpdateLock.lock();
        TaskState state = this.stateStorage.getState(id);
        if (state == null) {
            return this;
        }
        Pair<ScheduledFuture<?>, BackgroundTask> pair = this.instantiatedTasks.get(id);
        String name = this.getClass().getName();
        Pair<ScheduledFuture<?>, BackgroundTask> pair2 = pair;
        synchronized (pair2) {
            if (state.status() == TaskStatus.SCHEDULED || state.status() == TaskStatus.COMPLETED && state.isRecurring().booleanValue()) {
                this.LOG.info("Stopping a currently scheduled task " + id);
                ((ScheduledFuture)pair.getKey()).cancel(true);
                this.stateStorage.updateState(id, TaskStatus.STOPPED, name, null, null, null, null);
            } else if (state.status() == TaskStatus.RUNNING) {
                this.LOG.info("Stopping running task " + id);
                BackgroundTask task = (BackgroundTask)pair.getValue();
                if (task != null) {
                    task.stop();
                }
                this.stateStorage.updateState(id, TaskStatus.STOPPED, name, null, null, null, null);
            } else {
                this.LOG.warn("Task not running - " + id);
            }
        }
        this.stateUpdateLock.unlock();
        return this;
    }

    @Override
    public StateStorage storage() {
        return this.stateStorage;
    }

    private Runnable exceptionCatcher(String id, BackgroundTask task) {
        return () -> {
            try {
                task.start(this.saveCheckpoint(id), this.stateStorage.getState(id).configuration());
                this.stateUpdateLock.lock();
                if (this.stateStorage.getState(id).status() == TaskStatus.RUNNING) {
                    this.stateStorage.updateState(id, TaskStatus.COMPLETED, EXCEPTION_CATCHER_NAME, null, null, null, null);
                }
                this.stateUpdateLock.unlock();
            }
            catch (Throwable t) {
                this.stateStorage.updateState(id, TaskStatus.FAILED, EXCEPTION_CATCHER_NAME, null, t, null, null);
            }
        };
    }

    private Runnable runTask(String id, BackgroundTask task, Boolean recurring) {
        return () -> {
            this.stateUpdateLock.lock();
            TaskState state = this.stateStorage.getState(id);
            if (recurring.booleanValue() && (state.status() == TaskStatus.SCHEDULED || state.status() == TaskStatus.COMPLETED)) {
                this.stateStorage.updateState(id, TaskStatus.RUNNING, RUN_RECURRING_NAME, null, null, null, null);
                this.executorService.submit(this.exceptionCatcher(id, task));
            } else if (!recurring.booleanValue() && state.status() == TaskStatus.SCHEDULED) {
                this.stateStorage.updateState(id, TaskStatus.RUNNING, RUN_ONCE_NAME, null, null, null, null);
                this.executorService.submit(this.exceptionCatcher(id, task));
            }
            this.stateUpdateLock.unlock();
        };
    }

    private Consumer<String> saveCheckpoint(String id) {
        return s -> {
            this.stateUpdateLock.lock();
            this.stateStorage.updateState(id, this.stateStorage.getState(id).status(), SAVE_CHECKPOINT_NAME, null, null, (String)s, null);
            this.stateUpdateLock.unlock();
        };
    }
}

