/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.engine.postprocessing.Cache;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.exception.GraknEngineServerException;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import java.util.Collections;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Spark;

public class CommitLogController {
    private final Cache cache;
    private final Logger LOG = LoggerFactory.getLogger(CommitLogController.class);

    public CommitLogController() {
        this.cache = Cache.getInstance();
        Spark.post((String)"/commit_log", this::submitConcepts);
        Spark.delete((String)"/commit_log", this::deleteConcepts);
    }

    private String deleteConcepts(Request req, Response res) {
        String graphName = req.queryParams("graphName");
        if (graphName == null) {
            res.status(400);
            return ErrorMessage.NO_PARAMETER_PROVIDED.getMessage(new Object[]{"graphName", "delete"});
        }
        this.cache.getCastingJobs(graphName).clear();
        this.cache.getResourceJobs(graphName).clear();
        return "The cache of Graph [" + graphName + "] has been cleared";
    }

    private String submitConcepts(Request req, Response res) {
        try {
            String graphName = req.queryParams("graphName");
            if (graphName == null) {
                graphName = ConfigProperties.getInstance().getProperty("graphdatabase.default-graph-name");
            }
            this.LOG.info("Commit log received for graph [" + graphName + "]");
            JSONArray jsonArray = (JSONArray)new JSONObject(req.body()).get("concepts");
            block6: for (Object object : jsonArray) {
                JSONObject jsonObject = (JSONObject)object;
                String conceptId = jsonObject.getString("id");
                Schema.BaseType type = Schema.BaseType.valueOf((String)jsonObject.getString("type"));
                switch (type) {
                    case CASTING: {
                        this.cache.addJobCasting(graphName, Collections.singleton(conceptId));
                        continue block6;
                    }
                    case RESOURCE: {
                        this.cache.addJobResource(graphName, Collections.singleton(conceptId));
                    }
                }
                this.LOG.warn(ErrorMessage.CONCEPT_POSTPROCESSING.getMessage(new Object[]{conceptId, type.name()}));
            }
            long numJobs = this.getJobCount(this.cache.getCastingJobs(graphName));
            return "Graph [" + graphName + "] now has [" + (numJobs += this.getJobCount(this.cache.getResourceJobs(graphName))) + "] post processing jobs";
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }

    private long getJobCount(Set jobs) {
        if (jobs != null) {
            return jobs.size();
        }
        return 0L;
    }
}

