/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.exception.GraknEngineServerException;
import ai.grakn.util.ErrorMessage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Spark;

public class GraphFactoryController {
    private final Logger LOG = LoggerFactory.getLogger(GraphFactoryController.class);

    public GraphFactoryController() {
        ConfigProperties prop = ConfigProperties.getInstance();
        Spark.get((String)"/graph_factory", (req, res) -> {
            String graphConfig = req.queryParams("graphConfig");
            try {
                if (graphConfig == null) {
                    graphConfig = "graphdatabase.config";
                } else {
                    switch (graphConfig) {
                        case "default": {
                            graphConfig = "graphdatabase.config";
                            break;
                        }
                        case "batch": {
                            graphConfig = "graphdatabase.batch-config";
                            break;
                        }
                        case "computer": {
                            graphConfig = "graphdatabase.computer";
                        }
                    }
                }
                return new String(Files.readAllBytes(Paths.get(prop.getPath(graphConfig), new String[0])));
            }
            catch (IOException e) {
                throw new GraknEngineServerException(500, ErrorMessage.NO_CONFIG_FILE.getMessage(new Object[]{prop.getPath(graphConfig)}));
            }
        });
    }
}

