/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.engine.loader.BlockingLoader;
import ai.grakn.engine.loader.DistributedLoader;
import ai.grakn.engine.loader.Loader;
import ai.grakn.engine.postprocessing.PostProcessing;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.exception.GraknEngineServerException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.graql.Var;
import ai.grakn.graql.internal.parser.QueryParser;
import ai.grakn.util.ErrorMessage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Spark;

@Api(value="/import", description="Endpoints to import data and ontologies from Graqlfiles to a graph.")
@Path(value="/import")
@Produces(value={"text/plain"})
public class ImportController {
    private final Logger LOG = LoggerFactory.getLogger(ImportController.class);
    private ScheduledExecutorService checkLoadingExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture printingState;
    private AtomicLong processedEntities = new AtomicLong();
    private AtomicLong processedRelations = new AtomicLong();
    private AtomicBoolean loadingInProgress = new AtomicBoolean(false);
    private static final String INSERT_KEYWORD = "insert";
    private static final String MATCH_KEYWORD = "match";
    private String defaultGraphName;

    public ImportController() {
        Spark.before((String)"/import/batch/data", (req, res) -> {
            if (this.loadingInProgress.get()) {
                Spark.halt((int)423, (String)"Another loading process is still running.\n");
            }
        });
        Spark.before((String)"/import/distribute/data", (req, res) -> {
            if (this.loadingInProgress.get()) {
                Spark.halt((int)423, (String)"Another loading process is still running.\n");
            }
        });
        Spark.post((String)"/import/batch/data", this::importDataREST);
        Spark.post((String)"/import/distribute/data", this::importDataRESTDistributed);
        this.defaultGraphName = ConfigProperties.getInstance().getProperty("graphdatabase.default-graph-name");
    }

    @POST
    @Path(value="/distribute/data")
    @ApiOperation(value="Import data from a Graql file. It performs batch loading and distributed the batches to remote hosts.", notes="This is a separate import from ontology, since a batch loading is performed to optimise the loading speed. ")
    @ApiImplicitParams(value={@ApiImplicitParam(name="path", value="File path on the server.", required=true, dataType="string", paramType="body"), @ApiImplicitParam(name="hosts", value="Collection of hosts' addresses.", required=true, dataType="string", paramType="body")})
    private String importDataRESTDistributed(Request req, Response res) {
        this.loadingInProgress.set(true);
        try {
            JSONObject bodyObject = new JSONObject(req.body());
            String pathToFile = bodyObject.get("path").toString();
            String graphName = bodyObject.has("graphName") ? bodyObject.get("graphName").toString() : this.defaultGraphName;
            HashSet hosts = new HashSet();
            bodyObject.getJSONArray("hosts").forEach(x -> hosts.add((String)x));
            if (!new File(pathToFile).exists()) {
                throw new FileNotFoundException(ErrorMessage.NO_GRAQL_FILE.getMessage(new Object[]{pathToFile}));
            }
            Executors.newSingleThreadExecutor().submit(() -> this.importDataFromFile(pathToFile, new DistributedLoader(graphName, hosts)));
        }
        catch (FileNotFoundException | JSONException j) {
            this.loadingInProgress.set(false);
            throw new GraknEngineServerException(400, (Exception)j);
        }
        catch (Exception e) {
            this.loadingInProgress.set(false);
            throw new GraknEngineServerException(500, e);
        }
        return "Distributed loading successfully STARTED. \n";
    }

    @POST
    @Path(value="/batch/data")
    @ApiOperation(value="Import data from a Graql file. It performs batch loading.", notes="This is a separate import from ontology, since a batch loading is performed to optimise the loading speed. ")
    @ApiImplicitParam(name="path", value="File path on the server.", required=true, dataType="string", paramType="body")
    private String importDataREST(Request req, Response res) {
        this.loadingInProgress.set(true);
        try {
            String graphName;
            JSONObject bodyObject = new JSONObject(req.body());
            String pathToFile = bodyObject.get("path").toString();
            String string = graphName = bodyObject.has("graphName") ? bodyObject.get("graphName").toString() : this.defaultGraphName;
            if (!new File(pathToFile).exists()) {
                throw new FileNotFoundException(ErrorMessage.NO_GRAQL_FILE.getMessage(new Object[]{pathToFile}));
            }
            this.initialiseLoading();
            Executors.newSingleThreadExecutor().submit(() -> this.importDataFromFile(pathToFile, new BlockingLoader(graphName)));
        }
        catch (FileNotFoundException | JSONException j) {
            this.loadingInProgress.set(false);
            throw new GraknEngineServerException(400, (Exception)j);
        }
        catch (Exception e) {
            this.loadingInProgress.set(false);
            throw new GraknEngineServerException(500, e);
        }
        return "Loading successfully STARTED. \n";
    }

    private void initialiseLoading() {
        this.printingState = this.checkLoadingExecutor.scheduleAtFixedRate(this::checkLoadingStatus, 10L, 10L, TimeUnit.SECONDS);
        this.processedEntities.set(0L);
        this.processedRelations.set(0L);
    }

    private void checkLoadingStatus() {
        this.LOG.info("===== Import from file in progress ====");
        this.LOG.info("Processed Entities: " + this.processedEntities);
        this.LOG.info("Processed Relations: " + this.processedRelations);
        this.LOG.info("=======================================");
    }

    private void importDataFromFile(String dataFile, Loader loaderParam) {
        this.LOG.info("Data loading started.");
        try {
            Iterator<Object> batchIterator = QueryParser.create((QueryBuilder)Graql.withoutGraph()).parseBatchLoad((InputStream)new FileInputStream(dataFile)).iterator();
            if (batchIterator.hasNext()) {
                Object var = batchIterator.next();
                while (var.equals(INSERT_KEYWORD)) {
                    var = this.consumeInsertEntity(batchIterator, loaderParam);
                }
                loaderParam.waitToFinish();
                while (var.equals(MATCH_KEYWORD)) {
                    var = this.consumeInsertRelation(batchIterator, loaderParam);
                }
            }
            loaderParam.waitToFinish();
            this.LOG.info("Data loading complete:");
            this.checkLoadingStatus();
            this.printingState.cancel(true);
            this.processedEntities.set(0L);
            this.processedRelations.set(0L);
            this.loadingInProgress.set(false);
            PostProcessing.getInstance().run();
        }
        catch (Exception e) {
            this.LOG.error("Exception while batch loading data.", (Throwable)e);
            this.loadingInProgress.set(false);
        }
    }

    private Object consumeInsertEntity(Iterator<Object> batchIterator, Loader loader) {
        Object var = null;
        ArrayList<Var> insertQuery = new ArrayList<Var>();
        while (batchIterator.hasNext() && (var = batchIterator.next()) instanceof Var) {
            insertQuery.add((Var)var);
            this.processedEntities.incrementAndGet();
        }
        loader.add(Graql.insert(insertQuery));
        return var;
    }

    private Object consumeInsertRelation(Iterator<Object> batchIterator, Loader loader) {
        Object var = null;
        ArrayList<Var> insertQueryMatch = new ArrayList<Var>();
        while (batchIterator.hasNext() && (var = batchIterator.next()) instanceof Var) {
            insertQueryMatch.add((Var)var);
        }
        if (!var.equals(INSERT_KEYWORD)) {
            throw new GraknEngineServerException(500, "Match statement not followed by any Insert.");
        }
        ArrayList<Var> insertQuery = new ArrayList<Var>();
        while (batchIterator.hasNext() && (var = batchIterator.next()) instanceof Var) {
            insertQuery.add((Var)var);
        }
        loader.add(Graql.match(insertQueryMatch).insert(insertQuery));
        this.processedRelations.incrementAndGet();
        return var;
    }
}

