/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.engine.controller;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.engine.session.RemoteSession;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.exception.GraknEngineServerException;
import ai.grakn.factory.GraphFactory;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Printer;
import ai.grakn.graql.Reasoner;
import ai.grakn.graql.internal.printer.Printers;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Spark;

@Path(value="/shell")
@Api(value="/shell", description="Endpoints to execute match queries and obtain meta-ontology types instances.")
@Produces(value={"application/json", "text/plain"})
public class RemoteShellController {
    private final Logger LOG = LoggerFactory.getLogger(RemoteShellController.class);
    private final int WEBSOCKET_TIMEOUT = 3600000;
    String defaultGraphName = ConfigProperties.getInstance().getProperty("graphdatabase.default-graph-name");

    public RemoteShellController() {
        Spark.webSocket((String)"/shell/remote", RemoteSession.class);
        Spark.webSocketIdleTimeoutMillis((int)3600000);
        Spark.get((String)"/shell/match", this::matchQuery);
        Spark.get((String)"/shell/metaTypeInstances", this::buildMetaTypeInstancesObject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/metaTypeInstances")
    @ApiOperation(value="Produces a JSONObject containing meta-ontology types instances.", notes="The built JSONObject will contain ontology nodes divided in roles, entities, relations and resources.", response=JSONObject.class)
    @ApiImplicitParam(name="graphName", value="Name of graph tu use", dataType="string", paramType="query")
    private String buildMetaTypeInstancesObject(Request req, Response res) {
        String currentGraphName = req.queryParams("graphName");
        if (currentGraphName == null) {
            currentGraphName = this.defaultGraphName;
        }
        try (GraknGraph graph = GraphFactory.getInstance().getGraph(currentGraphName);){
            JSONObject responseObj = new JSONObject();
            responseObj.put("roles", (Object)new JSONArray((Object)graph.getMetaRoleType().instances().stream().map(Concept::getId).toArray()));
            responseObj.put("entities", (Object)new JSONArray((Object)graph.getMetaEntityType().instances().stream().map(Concept::getId).toArray()));
            responseObj.put("relations", (Object)new JSONArray((Object)graph.getMetaRelationType().instances().stream().map(Concept::getId).toArray()));
            responseObj.put("resources", (Object)new JSONArray((Object)graph.getMetaResourceType().instances().stream().map(Concept::getId).toArray()));
            String string = responseObj.toString();
            return string;
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/match")
    @ApiOperation(value="Executes match query on the server and produces a result string.")
    @ApiImplicitParams(value={@ApiImplicitParam(name="graphName", value="Name of graph to use", dataType="string", paramType="query"), @ApiImplicitParam(name="query", value="Match query to execute", required=true, dataType="string", paramType="query")})
    private String matchQuery(Request req, Response res) {
        String currentGraphName = req.queryParams("graphName");
        if (currentGraphName == null) {
            currentGraphName = this.defaultGraphName;
        }
        this.LOG.debug("Received match query: \"" + req.queryParams("query") + "\"");
        Printer printer = Printers.graql();
        try (GraknGraph graph = GraphFactory.getInstance().getGraph(currentGraphName);){
            MatchQuery matchQuery = (MatchQuery)graph.graql().parse(req.queryParams("query"));
            MatchQuery inferQuery = new Reasoner(graph).resolveToQuery(matchQuery);
            String string = inferQuery.resultsString(printer).map(x -> x.replaceAll("\u001b\\[\\d+[m]", "")).collect(Collectors.joining("\n"));
            return string;
        }
        catch (Exception e) {
            throw new GraknEngineServerException(500, e);
        }
    }
}

